/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;

/**
 * Interface that must be implemented in order to create
 * POJOs for the register request
 * 
 * 
 * @author David Whiteman
 */
public interface IRegisterInputArtifactFactory {

	/**
	 * Answer a new instance of IAdditionalRecordType
	 * 
	 * @param namespace
	 * @param localName
	 * @return
	 */
	public abstract IAdditionalRecordType createAdditionalRecordType(
			String namespace, String localName);

	/**
	 * @return
	 */
	public abstract IInstanceId createInstanceId();

	/**
	 * Answer a new instance of IInstanceId with the indicated attributes
	 * 
	 * @param mdrId URI string containing the MDR's ID
	 * @param localId URI string with the local ID of the instance
	 * @return
	 */
	public abstract IInstanceId createInstanceId(String mdrId, String localId);

	/**
	 * Answer a new instance of IItem
	 * 
	 * @return
	 */
	public abstract IItem createItem();

	/**
	 * Answer a new instance of {@link IItemList}, setting whether the list
	 * acts as a list id.
	 *  
	 * @param idList
	 * @return
	 */
	public abstract IItemList createItemList(boolean idList);

	/**
	 * Answer a new record as a child of the indicated parent graph element.
	 * 
	 * @param parent The parent element
	 * @param recordId The record ID
	 * 
	 * @return A new instance of record 
	 */
	public abstract IRecord createRecord(IGraphElement parent, String recordId);

	/**
	 * Answer a new record metadata
	 * 
	 * @return A new instance of record metadata
	 */
	public abstract IRecordMetadata createRecordMetadata();

	/**
	 * Answer a new instance of {@link IRegisterRequest}
	 * 
	 * @return
	 */
	public abstract IRegisterRequest createRegisterRequest();

	/**
	 * Answer a new instance of IRelationship
	 * 
	 * @return
	 */
	public abstract IRelationship createRelationship();

	/**
	 * Answer a new instance of {@link IRelationshipList}, setting whether the list
	 * acts as a list id.
	 *  
	 * @param idList
	 * @return
	 */
	public abstract IRelationshipList createRelationshipList(boolean idList);

}