/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.cosmos.rm.internal.repository.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.internal.repository.operations.IValidationOutputFactory;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.SMLDocuments;
import org.eclipse.cosmos.rm.internal.validation.artifacts.SchemaBindings;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ValidationSet;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.FileOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.common.SystemOutput;
import org.eclipse.cosmos.rm.internal.validation.core.FoundationBuilder;
import org.eclipse.cosmos.rm.internal.validation.core.ISMLValidator;
import org.eclipse.cosmos.rm.internal.validation.core.ISchematronValidation;
import org.eclipse.cosmos.rm.internal.validation.core.IValidationListener;
import org.eclipse.cosmos.rm.internal.validation.core.IValidator;
import org.eclipse.cosmos.rm.internal.validation.core.ValidationEvent;
import org.eclipse.cosmos.rm.internal.validation.core.ValidationFactory;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DocumentCacheBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.ElementSchematronCacheBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.SchemaBindingsBuilder;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.AcyclicValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.IdentityConstraintValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.ReferenceValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.SchemaValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.SchematronValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.TargetValidator;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.core.SMLRepositoryFactory;
import org.eclipse.cosmos.rm.provisional.repository.exception.MissingRepositoryException;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryConnectionException;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.operations.ISMLOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLMainValidator
implements IValidationListener {
    private static final String OPTION_SML = "-sml";
    private static final String OPTION_SCHEMATRON = "-schematron";
    private static final String OPTION_FILE = "-output";
    private static final String OPTION_CONTEXT = "-context";
    private static final String OPTION_CONFIGURATION = "-configuration";
    private static final String OPTION_SUPPRESS_WARNINGS = "-sw";
    private static final String SML_IF_SCHEMA = "validation-resources/smlif.xsd";
    private static String contextDirectory;
    private static String configurationFile;
    private static boolean suppressWarnings;
    private static IValidationOutputFactory validationOutputFactory;
    private static IValidationOutputFactory defaultValidationOutputFactory;
    private Map<String, Object> attributes = new Hashtable<String, Object>();
    private IProgressMonitor monitor;

    static {
        defaultValidationOutputFactory = new IValidationOutputFactory(){

            public AbstractValidationOutput createEclipseOutput() {
                return new SystemOutput();
            }
        };
    }

    public SMLMainValidator() {
        this.setDefaultAttributes();
    }

    protected void setDefaultAttributes() {
        this.attributes.put("attribute.environment", "value.environment.standalone");
        ArrayList<String> smlValidators = new ArrayList<String>();
        smlValidators.add(SchemaValidator.class.getName());
        smlValidators.add(AcyclicValidator.class.getName());
        smlValidators.add(IdentityConstraintValidator.class.getName());
        smlValidators.add(TargetValidator.class.getName());
        smlValidators.add(SchematronValidator.class.getName());
        smlValidators.add(ReferenceValidator.class.getName());
        this.attributes.put("attribute.validation.sml", smlValidators);
        this.attributes.put("validation.schema.smlif", SML_IF_SCHEMA);
        this.attributes.put("validation.policy.fastfail", "false");
    }

    public void initialize(Map<String, Object> attributes) {
        for (String currentKey : attributes.keySet()) {
            this.setAttribute(currentKey, attributes.get(currentKey));
        }
        DataBuilderRegistry.getInstanceLevelRegistry().clear();
        DataBuilderRegistry topLevelRegistry = DataBuilderRegistry.getTopLevelRegistry();
        topLevelRegistry.clear();
        topLevelRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentCacheBuilder", (IDataBuilder)new DocumentCacheBuilder());
        topLevelRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.SchemaBindingDataBuilder", (IDataBuilder)new SchemaBindingsBuilder());
        topLevelRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.IdentityDataBuilder", (IDataBuilder)new IdentityDataBuilder());
        topLevelRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder", (IDataBuilder)new ElementSchematronCacheBuilder());
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public boolean start() {
        AbstractValidationOutput validationOutput = (AbstractValidationOutput)this.attributes.get("validation.output");
        if (validationOutput == null) {
            validationOutput = this.createValidationOutput();
            this.attributes.put("validation.output", validationOutput);
        }
        if (validationOutput != null) {
            validationOutput.initialize(this.attributes);
        }
        this.monitor = (IProgressMonitor)this.attributes.get("validation.progress");
        this.monitor = this.monitor == null ? new NullProgressMonitor() : this.monitor;
        try {
            FoundationBuilder foundationBuilder = new FoundationBuilder(0);
            foundationBuilder.initialize(this.attributes);
            foundationBuilder.validate();
            List<IValidator> validators = this.createValidators();
            validators.add(0, (IValidator)new FoundationBuilder(1));
            List<ValidationSet> validationSets = this.createValidationSets();
            int validationSetCount = validationSets.size();
            this.monitor.beginTask(SMLValidationMessages.validationTask, validationSetCount * validators.size());
            int i = 0;
            while (i < validationSetCount) {
                this.reset(validators);
                ValidationSet validationSet = validationSets.get(i);
                this.attributes.put("validation.set", validationSet);
                this.initialize(validators);
                this.execute(validators);
                ++i;
            }
            boolean bl = validationOutput.getErrorCount() == 0;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            validationOutput.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage((int)-1, (String)(String.valueOf(SMLValidationMessages.errorValidatorInstantiation) + (message == null ? "" : message))));
        }
        finally {
            validationOutput.close();
        }
        return false;
    }

    private void reset(List<IValidator> validators) {
        int i = 0;
        int validatorCount = validators.size();
        while (i < validatorCount) {
            validators.get(i).reset();
            ++i;
        }
    }

    private void initialize(List<IValidator> validators) {
        int i = 0;
        int validatorCount = validators.size();
        while (i < validatorCount) {
            IValidator validator = validators.get(i);
            validator.initialize(this.attributes);
            validator.addValidationListener((IValidationListener)this);
            ++i;
        }
    }

    private void execute(List<IValidator> validators) {
        int remainingWork;
        int currentIndex = 0;
        int validatorCount = validators.size();
        while (currentIndex < validatorCount) {
            IValidator validator = validators.get(currentIndex);
            if (this.monitor.isCanceled() || !validator.validate() && this.fastFailPolicy()) break;
            this.monitor.worked(1);
            ++currentIndex;
        }
        if ((remainingWork = validators.size() - currentIndex) > 0) {
            this.monitor.worked(remainingWork);
        }
    }

    private List<ValidationSet> createValidationSets() {
        ArrayList<ValidationSet> validationSets = new ArrayList<ValidationSet>();
        SchemaBindings schemaBindings = (SchemaBindings)SMLValidatorUtil.retrieveDataStructure((int)0, (String)"org.eclipse.cosmos.rm.validation.SchemaBindingDataBuilder");
        SMLDocuments smlDocuments = (SMLDocuments)SMLValidatorUtil.retrieveDataStructure((int)0, (String)"org.eclipse.cosmos.rm.validation.DocumentCacheBuilder");
        if (!schemaBindings.isPresent()) {
            ValidationSet validationSet = new ValidationSet();
            ElementSchemaModel[] definitions = smlDocuments.getDefinitions();
            int i = 0;
            while (i < definitions.length) {
                validationSet.addDefinitionDocument(definitions[i]);
                ++i;
            }
            ElementModel[] instances = smlDocuments.getInstances();
            int i2 = 0;
            while (i2 < instances.length) {
                validationSet.addInstanceDocument(instances[i2]);
                ++i2;
            }
            validationSets.add(validationSet);
        } else {
            ElementModel instanceDocument;
            SchemaBindings.SchemaBinding[] bindings = schemaBindings.getBindings();
            ArrayList<ElementSchemaModel> addedDefinitions = new ArrayList<ElementSchemaModel>();
            ArrayList<ElementModel> addedInstances = new ArrayList<ElementModel>();
            SchemaBindings.SchemaBinding defaultBinding = schemaBindings.getDefaultBinding();
            ElementSchemaModel[] defaultSchemaElements = null;
            if (defaultBinding != null) {
                String[] defaultSchemas = defaultBinding.getSchemaAliases();
                int i = 0;
                while (i < defaultSchemas.length) {
                    ElementSchemaModel defaultSchema = smlDocuments.getDefinitionByAlias(defaultSchemas[i]);
                    if (defaultSchemas != null) {
                        addedDefinitions.add(defaultSchema);
                    }
                    ++i;
                }
                if (!addedDefinitions.isEmpty()) {
                    defaultSchemaElements = addedDefinitions.toArray(new ElementSchemaModel[addedDefinitions.size()]);
                }
            }
            int i = 0;
            while (i < bindings.length) {
                String[] aliases = bindings[i].getDocumentAliases();
                ValidationSet validationSet = new ValidationSet();
                int j = 0;
                while (j < aliases.length) {
                    instanceDocument = smlDocuments.getInstanceByAlias(aliases[j]);
                    if (instanceDocument != null) {
                        validationSet.addInstanceDocument(instanceDocument);
                        addedInstances.add(instanceDocument);
                    }
                    ++j;
                }
                aliases = bindings[i].getSchemaAliases();
                j = 0;
                while (j < aliases.length) {
                    ElementSchemaModel elementSchemaModel = smlDocuments.getDefinitionByAlias(aliases[j]);
                    if (elementSchemaModel != null) {
                        validationSet.addDefinitionDocument(elementSchemaModel);
                        addedDefinitions.add(elementSchemaModel);
                    }
                    ++j;
                }
                if (!validationSet.isEmpty()) {
                    validationSets.add(validationSet);
                }
                ++i;
            }
            SchemaBindings.SchemaBinding noSchemaBindings = schemaBindings.getNoSchemaBindings();
            ArrayList<ElementModel> noSchemaBindingsList = new ArrayList<ElementModel>();
            if (noSchemaBindings != null) {
                String[] documentAliases = noSchemaBindings.getDocumentAliases();
                int i3 = 0;
                while (i3 < documentAliases.length) {
                    instanceDocument = smlDocuments.getInstanceByAlias(documentAliases[i3]);
                    if (instanceDocument != null) {
                        noSchemaBindingsList.add(instanceDocument);
                    }
                    ++i3;
                }
            }
            if (defaultSchemaElements != null) {
                ElementModel[] instances = smlDocuments.getInstances();
                ValidationSet defaultValidationSet = new ValidationSet();
                boolean foundUnboundInstance = false;
                int i4 = 0;
                while (i4 < instances.length) {
                    if (!addedInstances.contains(instances[i4]) && !noSchemaBindingsList.contains(instances[i4])) {
                        foundUnboundInstance = true;
                        defaultValidationSet.addInstanceDocument(instances[i4]);
                    }
                    ++i4;
                }
                if (foundUnboundInstance) {
                    defaultValidationSet.addDefinitionDocuments(defaultSchemaElements);
                    validationSets.add(defaultValidationSet);
                }
            }
            ElementSchemaModel[] definitions = smlDocuments.getDefinitions();
            ValidationSet dummySet = new ValidationSet();
            int i5 = 0;
            while (i5 < definitions.length) {
                if (!addedDefinitions.contains(definitions[i5])) {
                    dummySet.addDefinitionDocument(definitions[i5]);
                }
                ++i5;
            }
            if (!dummySet.isEmpty()) {
                validationSets.add(dummySet);
            }
        }
        return validationSets;
    }

    private List<IValidator> createValidators() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ArrayList<IValidator> validators = new ArrayList<IValidator>();
        this.addEntries(validators, ValidationFactory.createValidator(ISMLValidator.class, (Object)this.attributes.get("attribute.validation.sml")));
        this.addEntries(validators, ValidationFactory.createValidator(ISchematronValidation.class, (Object)this.attributes.get("attribute.validation.schematron")));
        return validators;
    }

    private void addEntries(List<IValidator> validators, IValidator[] entries) {
        int i = 0;
        while (i < entries.length) {
            validators.add(entries[i]);
            ++i;
        }
    }

    private boolean fastFailPolicy() {
        String fastFail = (String)this.attributes.get("validation.policy.fastfail");
        if (fastFail != null) {
            return Boolean.valueOf(fastFail);
        }
        return false;
    }

    protected AbstractValidationOutput createValidationOutput() {
        String environment = (String)this.attributes.get("attribute.environment");
        Object validationOutput = null;
        validationOutput = "value.environment.eclipse".equals(environment) ? this.createEclipseOutput() : ("value.environment.standalone".equals(environment) ? new FileOutput() : new SystemOutput());
        return validationOutput;
    }

    protected AbstractValidationOutput createEclipseOutput() {
        return SMLMainValidator.getEclipseValidationOutputFactory().createEclipseOutput();
    }

    public static IValidationOutputFactory getEclipseValidationOutputFactory() {
        if (validationOutputFactory == null) {
            return defaultValidationOutputFactory;
        }
        return validationOutputFactory;
    }

    public static void setEclipseValidationOutputFactory(IValidationOutputFactory factory) {
        validationOutputFactory = factory;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            SMLMainValidator.printUsage();
            return;
        }
        int lastInx = -1;
        int currentInx = 0;
        Hashtable<String, Object> validationAttributes = new Hashtable<String, Object>();
        try {
            while (lastInx != currentInx) {
                lastInx = currentInx;
                currentInx = SMLMainValidator.processOption(validationAttributes, args, currentInx);
            }
            if (currentInx != args.length - 1) {
                SMLMainValidator.printUsage();
                return;
            }
            validationAttributes.put("attribute.environment", "value.environment.standalone");
            if (System.getProperty("org.eclipse.cosmos.rm.repository") == null) {
                System.setProperty("org.eclipse.cosmos.rm.repository", FileSystemSMLRepository.class.getName());
            }
            ISMLRepository repository = SMLRepositoryFactory.createRepository();
            Hashtable<String, Object> repositoryAttributes = new Hashtable<String, Object>();
            if (configurationFile != null) {
                repositoryAttributes.put("org.eclipse.cosmos.rm.repository.ATTRIBUTE_CONFIGURATION_PROPERTY", configurationFile);
            } else if (contextDirectory != null) {
                repositoryAttributes.put("root.directory", contextDirectory);
            } else {
                repositoryAttributes.put("root.directory", System.getProperty("user.dir"));
            }
            repository.connect(repositoryAttributes);
            ISMLOperation validationOperation = repository.getOperation("org.eclipse.cosmos.rm.provisional.repository.operations.ISMLValidateOperation");
            StringTokenizer resources = new StringTokenizer(args[currentInx], ",");
            StringBuffer smlModelUnits = new StringBuffer();
            if (suppressWarnings) {
                validationAttributes.put("validation.suppress.warnings", Boolean.TRUE);
            }
            validationAttributes.put("validation.input.type", "value.sml.if");
            while (resources.hasMoreTokens()) {
                String currentResource = resources.nextToken();
                try {
                    int documentType;
                    String fullPath = currentResource;
                    String contextDirectory = repository.getProperty("root.directory", "");
                    if (!currentResource.startsWith(contextDirectory)) {
                        fullPath = String.valueOf(contextDirectory) + (contextDirectory.endsWith("/") || contextDirectory.endsWith("\\") ? "" : "/") + currentResource;
                    }
                    if ((documentType = SMLValidatorUtil.identifyDocumentType((File)new File(fullPath))) == 2) {
                        validationAttributes.put("validation.instance", fullPath);
                        validationOperation.setArguments(new Object[]{validationAttributes});
                        validationOperation.run();
                        continue;
                    }
                    if (documentType == 3) continue;
                    smlModelUnits.append(currentResource).append(",");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (smlModelUnits.length() > 0) {
                smlModelUnits.deleteCharAt(smlModelUnits.length() - 1);
                validationAttributes.put("validation.input.type", "value.sml.unit");
                validationAttributes.put("validation.instance", smlModelUnits.toString());
                validationOperation.setArguments(new Object[]{validationAttributes});
                validationOperation.run();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SMLMainValidator.printUsage();
        }
        catch (MissingRepositoryException e) {
            e.printStackTrace();
        }
        catch (RepositoryConnectionException e) {
            e.printStackTrace();
        }
        catch (RepositoryOperationException e) {
            e.printStackTrace();
        }
    }

    private static int processOption(Map<String, Object> attributes, String[] args, int inx) throws IllegalArgumentException {
        if (inx < 0 || inx >= args.length) {
            return inx;
        }
        String currentOption = args[inx];
        if (OPTION_SCHEMATRON.equals(currentOption)) {
            ++inx;
            inx = SMLMainValidator.addAttribute(attributes, args, inx, "attribute.validation.schematron");
        } else if (OPTION_SML.equals(currentOption)) {
            ArrayList<String> smlValidators = new ArrayList<String>();
            while (++inx < args.length - 1 && !args[inx].startsWith("-")) {
                StringTokenizer st = new StringTokenizer(args[inx]);
                while (st.hasMoreTokens()) {
                    smlValidators.add(st.nextToken());
                }
            }
            if (smlValidators.isEmpty()) {
                throw new IllegalArgumentException();
            }
            attributes.put("attribute.validation.sml", smlValidators);
        } else if (OPTION_FILE.equals(currentOption)) {
            ++inx;
            inx = SMLMainValidator.addAttribute(attributes, args, inx, "attribute.file.output");
        } else if (OPTION_CONTEXT.equals(currentOption)) {
            contextDirectory = args[++inx];
            ++inx;
        } else if (OPTION_CONFIGURATION.equals(currentOption)) {
            configurationFile = args[++inx];
            ++inx;
        } else if (OPTION_SUPPRESS_WARNINGS.equals(currentOption)) {
            suppressWarnings = true;
            ++inx;
        }
        return inx;
    }

    private static int addAttribute(Map<String, Object> attributes, String[] args, int inx, String attribute) throws IllegalArgumentException {
        if (inx >= args.length || args[inx].startsWith("-")) {
            throw new IllegalArgumentException();
        }
        attributes.put(attribute, args[inx]);
        return inx + 1;
    }

    private static void printUsage() {
        System.err.println(SMLValidationMessages.errorIllegalArguments);
    }

    public void validationErrorOccurred(ValidationEvent event) {
        event.continueOnError = !this.fastFailPolicy();
    }
}

