/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim.handler;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintValueType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class FileSystemHandler
implements IResourceHandler {
    static final QName FS = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_FileSystem");
    static final QName FS_AvailableSpace = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_FileSystem.AvailableSpace");
    static final String CMD_DIR = "cmd.exe /c dir \"{0}\"";
    static final String CMD_DF = "df -k {0}";
    static final String Windows = "Windows";
    static final Pattern PATTERN_DIR = Pattern.compile("([0-9,]+) bytes free");
    static final Pattern PATTERN_DF = Pattern.compile("(.*)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+");
    static final String OS_NAME = "os.name";

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, CapacityConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConsumptionConstraintType constraint) {
        if (FS_AvailableSpace.equals(constraint.getPropertyName())) {
            Long freeSpace;
            ConsumptionConstraintValueType value = constraint.getValue();
            Long limit = Long.parseLong(value.getValue());
            if (value.getUnit() != null && value.getUnit().equals("512-blocks")) {
                limit = limit * 512L;
            }
            return (freeSpace = (Long)this.getPropertyValue(ctxt, rsrc, constraint.getPropertyName())).compareTo(limit) >= 0;
        }
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, PropertyConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConditionalPropertyConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, VersionConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, RequirementResourceConstraintType constraint) {
        boolean result = true;
        for (Object o : constraint.getResourceConstraintGroup()) {
            if (!(o instanceof JAXBElement)) continue;
            Object value = ((JAXBElement)o).getValue();
            if (value instanceof PropertyConstraintType) {
                result = result && this.evaluate(ctxt, rsrc, (PropertyConstraintType)value);
                continue;
            }
            if (value instanceof ConsumptionConstraintType) {
                result = result && this.evaluate(ctxt, rsrc, (ConsumptionConstraintType)value);
                continue;
            }
            if (!(value instanceof VersionConstraintType)) continue;
            boolean bl = result = result && this.evaluate(ctxt, rsrc, (VersionConstraintType)value);
        }
        return result;
    }

    public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname) {
        if (FS.equals(rsrc.getType()) && FS_AvailableSpace.equals(qname)) {
            return this.getFreeSpace(ctxt.substituteVariables(rsrc.getName()));
        }
        return null;
    }

    public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
        return null;
    }

    private Long getFreeSpace(String directoryName) {
        try {
            String os = System.getProperty(OS_NAME);
            String command = os.contains(Windows) ? MessageFormat.format(CMD_DIR, directoryName) : MessageFormat.format(CMD_DF, directoryName);
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            if (process == null) {
                return 0L;
            }
            BufferedReader inStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            String output = null;
            while ((line = inStream.readLine()) != null) {
                output = line;
            }
            if (os.contains(Windows)) {
                return this.windowsFreeSpace(output);
            }
            return this.unixFreeSpace(output);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private Long unixFreeSpace(String s) {
        Matcher m;
        if (s != null && (m = PATTERN_DF.matcher(s)).find()) {
            return Long.parseLong(m.group(4)) * 1024L;
        }
        return 0L;
    }

    private Long windowsFreeSpace(String s) {
        Matcher m;
        if (s != null && (m = PATTERN_DIR.matcher(s)).find()) {
            return Long.parseLong(m.group(1).replace(",", ""));
        }
        return 0L;
    }
}

