/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.cosmos.me.sdd.advisor.IAdvisor;
import org.eclipse.cosmos.me.sdd.cli.Messages;
import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;

public class CLIAdvisor
implements IAdvisor {
    private static final String ONE = "1";
    private static final String ZERO = "0";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
    private Properties properties;

    public void setProperties(Properties descriptorLanguageBundle) {
        this.properties = descriptorLanguageBundle;
    }

    public void displayMessage(String message) {
        System.out.println(message);
    }

    public Integer requestParameter(IntegerParameterType ipt) {
        String name;
        String string = name = this.properties != null ? ipt.getDescription().getTranslationKey() : null;
        if (name != null) {
            name = this.getPropertyValue(name);
        }
        String value = this.readVariable(name != null ? name : null, ipt.getDefaultValue());
        Integer returnVal = null;
        try {
            returnVal = Integer.parseInt(value);
        }
        catch (Exception exception) {
            this.displayMessage(Messages.getString("CLIAdvisor.ProvideEntry"));
            return this.requestParameter(ipt);
        }
        return returnVal;
    }

    public String requestParameter(StringParameterType spt) {
        String name;
        String string = name = this.properties != null ? spt.getDescription().getTranslationKey() : null;
        if (name != null) {
            name = this.getPropertyValue(name);
        }
        return this.readVariable(name != null ? name : null, spt.getDefaultValue());
    }

    public Boolean requestParameter(BooleanParameterType bpt) {
        String value;
        String name;
        String string = name = this.properties != null ? bpt.getDescription().getTranslationKey() : null;
        if (name != null) {
            name = this.getPropertyValue(name);
        }
        if ((value = this.readVariable(name != null ? name : null, bpt.getDefaultValue())).equalsIgnoreCase(ONE)) {
            return true;
        }
        if (value.equalsIgnoreCase(ZERO)) {
            return false;
        }
        if (value.equalsIgnoreCase(TRUE)) {
            return true;
        }
        if (value.equalsIgnoreCase(FALSE)) {
            return false;
        }
        this.displayMessage(Messages.getString("CLIAdvisor.ProvideEntry"));
        return this.requestParameter(bpt);
    }

    public URI requestParameter(URIParameterType upt) {
        String name;
        String string = name = this.properties != null ? upt.getDescription().getTranslationKey() : null;
        if (name != null) {
            name = this.getPropertyValue(name);
        }
        URI returnVal = null;
        try {
            returnVal = URI.create(this.readVariable(name != null ? name : null, upt.getDefaultValue()));
        }
        catch (Exception exception) {
            return this.requestParameter(upt);
        }
        return returnVal;
    }

    private String readVariable(String name, String defaultVal) {
        boolean hasDefault = false;
        if (name == null) {
            name = Messages.getString("CLIAdvisor.MissingDisplayName");
        }
        if (defaultVal != null && defaultVal.length() > 0) {
            hasDefault = true;
            System.out.print(Messages.getString("CLIAdvisor.UseDefault", name, defaultVal));
        } else {
            System.out.print(Messages.getString("CLIAdvisor.ProvideValue", name));
        }
        String value = null;
        try {
            value = this.br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (value == null || value.length() == 0) {
            value = hasDefault ? defaultVal : this.readVariable(name, defaultVal);
        }
        return value;
    }

    public void displayError(RequirementResourceConstraintType resource) {
        if (resource == null || resource.getResourceRef() == null) {
            this.displayMessage("A resource has failed to be resolved or its handler can not be loaded.");
        } else {
            ResourceType rsrc = (ResourceType)resource.getResourceRef();
            this.displayMessage(Messages.getString("CLIAdvisor.FailedResolution", resource.getId(), rsrc.getName()));
        }
    }

    private String getPropertyValue(String translationKey) {
        String[] allKeys = translationKey.split(",");
        if (allKeys.length == 0) {
            return null;
        }
        if (allKeys.length == 1) {
            return this.properties.getProperty(allKeys[0]);
        }
        Object[] substitutions = new String[allKeys.length - 1];
        String initialValue = this.properties.getProperty(allKeys[0]);
        int i = 1;
        while (i < allKeys.length) {
            substitutions[i - 1] = this.properties.getProperty(allKeys[i]);
            ++i;
        }
        return MessageFormat.format(initialValue, substitutions);
    }
}

