/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim.handler;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.profile.cim.J2eeJVMType;
import org.eclipse.cosmos.me.sdd.profile.cim.Version;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintValueType;
import org.eclipse.cosmos.me.sdd.schema.VersionRangeType;
import org.eclipse.cosmos.me.sdd.schema.VersionValueType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class JREHandler
extends J2eeJVMType
implements IResourceHandler {
    static final String SUN = "sun";
    static final String IBM = "IBM";
    static final String BEA = "BEA";

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, CapacityConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConsumptionConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, PropertyConstraintType constraint) {
        if (constraint.getPropertyName().equals(VENDOR)) {
            VENDOR_VALUE = constraint.getValue();
            return JREHandler.resolveVendor(VENDOR_VALUE);
        }
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConditionalPropertyConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, VersionConstraintType constraint) {
        List versions = (List)this.getVersionValue(ctxt, rsrc);
        Iterator versionIter = versions.iterator();
        while (versionIter.hasNext()) {
            Version v;
            Version version = new Version((String)versionIter.next());
            VersionConstraintValueType supported = constraint.getSupported();
            if (supported == null) continue;
            for (VersionValueType value : supported.getValue()) {
                v = new Version(value.getVersion());
                if (version.compareTo(v) != 0) continue;
                return true;
            }
            for (VersionRangeType range : supported.getRange()) {
                if (range.getMinVersion() != null && version.compareTo(v = new Version(range.getMinVersion())) < 0 || range.getMaxVersion() != null && version.compareTo(v = new Version(range.getMaxVersion().getValue())) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
        ArrayList<String> versions = new ArrayList<String>();
        if (Utilities.getOS() == 1) {
            if (!JNIUtils.libraryLoaded((String)JREHandler.getCurrentPath(), (HashMap)WinRegAPI.libNames)) return versions;
            String[] sunVersions = WinRegAPI.childrenForKey32((int)8, (String)"SOFTWARE\\JavaSoft\\Java Runtime Environment\\");
            int i = 0;
            while (i < sunVersions.length) {
                versions.add(sunVersions[i]);
                ++i;
            }
            String[] BEAVersions = WinRegAPI.childrenForKey32((int)8, (String)"SOFTWARE\\JRockit\\Java Runtime Environment\\");
            int i2 = 0;
            while (i2 < BEAVersions.length) {
                versions.add(BEAVersions[i2]);
                ++i2;
            }
            return versions;
        } else {
            if (Utilities.getOS() != 2) return versions;
            try {
                String output = ".jrever";
                String script = "jrescript";
                File scriptFile = new File(script);
                PrintStream out = new PrintStream(new FileOutputStream(scriptFile));
                out.println("#!/bin/sh");
                out.println("if [ -f " + output + " ]; then ");
                out.println("  rm -f " + output);
                out.println("fi");
                out.println("export LANG=en_US");
                out.println("java -version 1>" + output + " 2>&1");
                out.close();
                Process scriptProc = Runtime.getRuntime().exec("chmod 755 " + script);
                scriptProc.waitFor();
                scriptProc = null;
                String command = "/bin/sh -c ./" + script;
                Process javaVer = Runtime.getRuntime().exec(command);
                javaVer.waitFor();
                scriptFile.delete();
                File outputFile = new File(output);
                if (!outputFile.isFile()) return versions;
                BufferedReader in = new BufferedReader(new FileReader(outputFile));
                String line = in.readLine();
                if (line != null) {
                    int firstQuote = line.indexOf("\"");
                    int lastQuote = line.indexOf("\"", firstQuote + 1);
                    if (firstQuote > -1 && lastQuote > -1) {
                        versions.add(line.substring(firstQuote + 1, lastQuote));
                    }
                }
                in.close();
                outputFile.delete();
                return versions;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return versions;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, RequirementResourceConstraintType constraint) {
        boolean result = true;
        for (Object o : constraint.getResourceConstraintGroup()) {
            if (!(o instanceof JAXBElement)) continue;
            Object value = ((JAXBElement)o).getValue();
            if (value instanceof PropertyConstraintType) {
                result = result && this.evaluate(ctxt, rsrc, (PropertyConstraintType)value);
                continue;
            }
            if (!(value instanceof VersionConstraintType)) continue;
            boolean bl = result = result && this.evaluate(ctxt, rsrc, (VersionConstraintType)value);
        }
        return result;
    }

    private static boolean resolveVendor(String vendor) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (Utilities.getOS() != 1) break block7;
                        if (JNIUtils.libraryLoaded((String)JREHandler.getCurrentPath(), (HashMap)WinRegAPI.libNames) && (vendor.equalsIgnoreCase(SUN) ? WinRegAPI.isWindowsRegistryKey32((int)8, (String)"SOFTWARE\\JavaSoft\\Java Runtime Environment\\") : (vendor.equalsIgnoreCase(IBM) ? WinRegAPI.getWindowsRegistryValue((int)8, (String)"SOFTWARE\\IBM\\MQSeries\\CurrentVersion\\Components", (String)"Server") != null : vendor.equalsIgnoreCase(BEA) && WinRegAPI.isWindowsRegistryKey32((int)8, (String)"SOFTWARE\\JRockit\\Java Runtime Environment\\")))) {
                            return true;
                        }
                        break block8;
                    }
                    if (Utilities.getOS() != 2) break block8;
                    if (!vendor.equalsIgnoreCase(SUN)) break block9;
                    int i = 0;
                    while (i < unixPatterns.length) {
                        String s = JREHandler.unixFind(MessageFormat.format(unixPatterns[i], "JRE", "", "SUN"));
                        if (s != null) {
                            return true;
                        }
                        ++i;
                    }
                    break block8;
                }
                if (!vendor.equalsIgnoreCase(IBM)) break block10;
                int i = 0;
                while (i < unixPatterns.length) {
                    String s = JREHandler.unixFind(MessageFormat.format(unixPatterns[i], "JRE", "", IBM));
                    if (s != null) {
                        return true;
                    }
                    ++i;
                }
                break block8;
            }
            if (!vendor.equalsIgnoreCase(BEA)) break block8;
            int i = 0;
            while (i < unixPatterns.length) {
                String s = JREHandler.unixFind(MessageFormat.format(unixPatterns[i], "JRE", "", BEA));
                if (s != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

