/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.BooleanParameterImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpressionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ConditionalDerivedVariableImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.DerivedVariableImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.IntegerParameterImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.OutputVariableImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ParameterBoundaryImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ParameterGroupImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ResourcePropertyImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.StringParameterImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.URIParameterImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.IntegerParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.OutputVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterBoundary;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.StringParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.URIParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.VariableFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFactoryImpl
implements VariableFactory {
    private SPISessionImpl session;
    private static final String DERIVED_VARIABLE_TYPE = "sdd-dd:DerivedVariableType";

    public VariableFactoryImpl(SPISessionImpl session) {
        this.session = session;
    }

    @Override
    public BooleanParameter createBooleanParameter(String parameterID) {
        this.session.testParameter(parameterID, 1, null);
        Element booleanParamElement = this.session.createDeploymentElement("BooleanParameter");
        booleanParamElement.setAttribute("id", parameterID);
        return new BooleanParameterImpl(booleanParamElement, this.session);
    }

    @Override
    public ConditionalDerivedVariable createConditionalDerivedVariable(String variableID, Collection<ConditionalDerivedVariableExpression> cdvExpressions) {
        this.session.testParameter(variableID, 1, null);
        this.session.testParameter(cdvExpressions, 2, null);
        for (ConditionalDerivedVariableExpression cdve : cdvExpressions) {
            if (cdve != null) continue;
            throw new InvalidInputException(2, 1);
        }
        Element dvElement = this.session.createDeploymentElement("DerivedVariable");
        dvElement.setAttribute("id", variableID);
        for (ConditionalDerivedVariableExpression cdve : cdvExpressions) {
            this.session.insertNode((Node)dvElement, (SPIDataObject)((Object)cdve), DERIVED_VARIABLE_TYPE);
        }
        ConditionalDerivedVariableImpl cdv = new ConditionalDerivedVariableImpl(dvElement, this.session);
        return cdv;
    }

    @Override
    public ConditionalDerivedVariableExpression createConditionalDerivedVariableExpression(String expression, Condition condition) {
        this.session.testParameter(expression, 1, null);
        this.session.testParameter(condition, 2, null);
        Element cdveElement = this.session.createDeploymentElement("ConditionalExpression");
        ConditionalDerivedVariableExpressionImpl cdve = new ConditionalDerivedVariableExpressionImpl(cdveElement, this.session);
        cdve.setExpression(expression);
        cdve.setCondition(condition);
        return cdve;
    }

    @Override
    public DerivedVariable createDerivedVariable(String variableID, String expression) {
        return this.createDerivedVariable(variableID, expression, "DerivedVariable");
    }

    @Override
    public DerivedVariable createVariable(String variableID, String expression) {
        return this.createDerivedVariable(variableID, expression, "Variable");
    }

    private DerivedVariable createDerivedVariable(String variableID, String expression, String elementName) {
        this.session.testParameter(variableID, 1, null);
        this.session.testParameter(expression, 2, null);
        Element dvElement = this.session.createDeploymentElement(elementName);
        Element expElement = this.session.createDeploymentElement("Expression");
        expElement.setTextContent(expression);
        dvElement.setAttribute("id", variableID);
        this.session.insertNode((Node)dvElement, (Node)expElement, DERIVED_VARIABLE_TYPE);
        return new DerivedVariableImpl(dvElement, this.session);
    }

    @Override
    public IntegerParameter createIntegerParameter(String parameterID) {
        this.session.testParameter(parameterID, 1, null);
        Element integerParamElement = this.session.createDeploymentElement("IntegerParameter");
        integerParamElement.setAttribute("id", parameterID);
        return new IntegerParameterImpl(integerParamElement, this.session);
    }

    @Override
    public ParameterGroup createParameterGroup() {
        return new ParameterGroupImpl(this.session.createDeploymentElement("Parameters"), this.session);
    }

    @Override
    public ResourceProperty createResourceProperty(String variableID, String resourceReference) {
        this.session.testParameter(variableID, 1, null);
        this.session.testParameter(resourceReference, 2, null);
        Element rptElement = this.session.createDeploymentElement("ResourceProperty");
        rptElement.setAttribute("resourceRef", resourceReference);
        rptElement.setAttribute("id", variableID);
        return new ResourcePropertyImpl(rptElement, this.session);
    }

    @Override
    public StringParameter createStringParameter(String parameterID) {
        this.session.testParameter(parameterID, 1, null);
        Element stringParamElement = this.session.createDeploymentElement("StringParameter");
        stringParamElement.setAttribute("id", parameterID);
        return new StringParameterImpl(stringParamElement, this.session);
    }

    @Override
    public URIParameter createURIParameter(String parameterID) {
        this.session.testParameter(parameterID, 1, null);
        Element uriParamElement = this.session.createDeploymentElement("URIParameter");
        uriParamElement.setAttribute("id", parameterID);
        return new URIParameterImpl(uriParamElement, this.session);
    }

    @Override
    public ParameterBoundary createParameterBoundary() {
        Element boundaryElement = this.session.createDeploymentElement("Bounds");
        return new ParameterBoundaryImpl(boundaryElement, this.session);
    }

    @Override
    public OutputVariable createOutputVariable(String id) throws InvalidInputException {
        this.session.testParameter(id, 1, null);
        Element ovElement = this.session.createDeploymentElement("OutputVariable");
        ovElement.setAttribute("id", id);
        return new OutputVariableImpl(ovElement, this.session);
    }
}

