/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.AllTests;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.BTGApplication;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.util.PropertiesReader;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;

public class PropertiesReader_Test
extends TestCase {
    BTGApplication btgApp;

    public PropertiesReader_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.btgApp = new BTGApplication();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInvalidFileName() throws ParseException, IOException {
        PropertiesReader propsReader = new PropertiesReader("badFileName");
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"Did not throw FileNotFoundException when invalid file name is given.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testNoBTGProperties() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.NO_BTG_PROP);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"Did not throw ParseException when no BTG properties section is defined.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testInvalidBTGPluginID() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.INVALID_BTG_ID);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"Did not throw ParseException when invalid BTG ID is defined.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testBTGNoOutputFileNameBaseValue() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.BTG_NO_OUTPUTFILENAMEBASEVALUE);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"Did not throw ParseException when BTG property OutputFileNameBase has no value.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testBTGNoOutputFileNameBase() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.BTG_NO_OUTPUTFILENAMEBASE);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"Did not throw ParseException when BTG properties does not contain OutputFileNameBase.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testDuplicateBTGProperties() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.BTG_DUPLICATE_PROPERTIES);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"Did not throw ParseException when duplicate BTG properties were found.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testBTGWithUnsupportedProperty_Enabled() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.BTG_UNSUPPORTED_PROP_ENABLED);
        try {
            Collection<Properties> props = propsReader.getPropertiesList();
            for (Properties p : props) {
                if (!"org.eclipse.cosmos.me.deployment.sdd.tooling.btg".equals(p.get("PluginID"))) continue;
                propsReader.checkSupportedProperties(p, this.btgApp.getSupportedProperties());
            }
            PropertiesReader_Test.fail((String)"Did not throw ParseException when unsupported BTG property (Enabled) was found.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testBTGWithUnsupportedProperty_Other() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.BTG_UNSUPPORTED_PROP_OTHER);
        try {
            Collection<Properties> props = propsReader.getPropertiesList();
            for (Properties p : props) {
                if (!"org.eclipse.cosmos.me.deployment.sdd.tooling.btg".equals(p.get("PluginID"))) continue;
                propsReader.checkSupportedProperties(p, this.btgApp.getSupportedProperties());
            }
            PropertiesReader_Test.fail((String)"Did not throw ParseException when unsupported BTG property (Enabled) was found.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testUnknownPluginID() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.UNKNOWN_PLUGIN_ID);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.assertTrue((boolean)true);
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.fail((String)"ParseException was thrown with unknown plugin ID.");
        }
    }

    public void testInvalidPropertySyntax_NoEqualSymbol() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.INVALID_PROP_SYNTAX);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown with invalid property syntax.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testInvalidPropertySyntax_NoPropertyName() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.INVALID_PROP_SYNTAX2);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown with invalid property syntax.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testInvalidPropertySyntax_NoPropertyValue() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.INVALID_PROP_SYNTAX3);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown with invalid property syntax.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testInvalidFirstLine() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.INVALID_FIRST_LINE);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown with invalid first line in file.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testDuplicatePropertyInSection() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.DUPLICATE_PROPERTY_IN_SECTION);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"Did not throw ParseException when duplicate property was found in same section.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testInvalidNoProperty() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.INVALID_NO_PROPERTY);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown when no property was found in file.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testRPMNoEnabledProperty() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.RPM_NO_ENABLED_PROPERTY);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown when RPM plugin section has no enabled property.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testRPMNoFileNameProperty() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.RPM_NO_FILENAME_PROPERTY);
        try {
            Collection<Properties> props = propsReader.getPropertiesList();
            for (Properties p : props) {
                String pluginID = "org.eclipse.cosmos.me.deployment.sdd.tooling.btg.plugin.rpmreader";
                ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
                properties.add(new BTGProperty("FileName", true));
                if (!pluginID.equals(p.get("PluginID"))) continue;
                propsReader.checkSupportedProperties(p, properties);
            }
            PropertiesReader_Test.fail((String)"ParseException was not thrown when RPM plugin section has no filename property.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testAggregatorNoEnabledProperty() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.AGGREGATOR_NO_ENABLED_PROPERTY);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown when Aggregator plugin section has no enabled property.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testAggregatorNoRuleLocationProperty() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.AGGREGATOR_NO_RULELOCATION_PROPERTY);
        try {
            Collection<Properties> props = propsReader.getPropertiesList();
            for (Properties p : props) {
                String pluginID = "org.eclipse.cosmos.me.deployment.sdd.tooling.btg.aggregator";
                ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
                properties.add(new BTGProperty("RulesLocation", true));
                if (!pluginID.equals(p.get("PluginID"))) continue;
                propsReader.checkSupportedProperties(p, properties);
            }
            PropertiesReader_Test.fail((String)"ParseException was not thrown when Aggregator plugin section has no RuleLocation property.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testSDDReaderNoEnabledProperty() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.SDDREADER_NO_ENABLED_PROPERTY);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown when SDDReader plugin section has no enabled property.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testSDDReaderNoFileNameProperty() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.SDDREADER_NO_FILENAME_PROPERTY);
        try {
            Collection<Properties> props = propsReader.getPropertiesList();
            for (Properties p : props) {
                String pluginID = "org.eclipse.cosmos.me.deployment.sdd.tooling.btg.plugin.sddreader";
                ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
                properties.add(new BTGProperty("FileName", true));
                if (!pluginID.equals(p.get("PluginID"))) continue;
                propsReader.checkSupportedProperties(p, properties);
            }
            PropertiesReader_Test.fail((String)"ParseException was not thrown when SDDReader plugin section has no filename property.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testLastSectionNoProperties() throws FileNotFoundException, IOException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.LAST_SECTION_NO_PROPERTIES);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.fail((String)"ParseException was not thrown when last section has no properties.");
        }
        catch (ParseException parseException) {
            PropertiesReader_Test.assertTrue((boolean)true);
        }
    }

    public void testValidPropertiesFile() throws FileNotFoundException, IOException, ParseException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.VALID_PROP);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.assertTrue((boolean)true);
        }
        catch (ParseException e) {
            PropertiesReader_Test.fail((String)("Valid Properties file has ParseException: " + e.getMessage()));
        }
    }

    public void testBTGSectionOnly() throws FileNotFoundException, IOException, ParseException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.BTG_SECTION_ONLY);
        try {
            propsReader.getPropertiesList();
            PropertiesReader_Test.assertTrue((boolean)true);
        }
        catch (ParseException e) {
            PropertiesReader_Test.fail((String)("Properties file has ParseException: " + e.getMessage()));
        }
    }

    public void testEnabledPluginAdded() throws FileNotFoundException, IOException, ParseException {
        PropertiesReader propsReader = new PropertiesReader(AllTests.VALID_ONE_PLUGIN_ENABLED);
        try {
            Collection<Properties> props = propsReader.getPropertiesList();
            String pluginID = "org.eclipse.cosmos.me.deployment.sdd.tooling.btg.plugin.rpmreader";
            PropertiesReader_Test.assertEquals((Object)"org.eclipse.cosmos.me.deployment.sdd.tooling.btg", (Object)props.toArray(new Properties[0])[0].get("PluginID"));
            PropertiesReader_Test.assertEquals((Object)pluginID, (Object)props.toArray(new Properties[0])[1].get("PluginID"));
            PropertiesReader_Test.assertEquals((int)2, (int)props.size());
        }
        catch (ParseException e) {
            PropertiesReader_Test.fail((String)("Properties file has ParseException: " + e.getMessage()));
        }
    }
}

