/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class Resource_Test
extends TestCase {
    Resource resource;
    Resource clonedResource;
    Element element;
    SPISessionImpl session;

    public Resource_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resource = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResource("testResourceID", "testResourceType");
        this.resource.setDescription(new TranslatableString("testDescription", "testKey"));
        this.resource.setName("testName");
        this.resource.setShortDescription(new TranslatableString("testShortDescription", "testShortKey"));
        Resource hostedResource1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testHosted1ResourceID", "testHosted1ResourceType");
        hostedResource1.setDescription(new TranslatableString("testHosted1Description", "testHosted1Key"));
        hostedResource1.setName("testHosted1Name");
        hostedResource1.setShortDescription(new TranslatableString("testHosted1ShortDescription", "testHosted1ShortKey"));
        Resource hostedResource2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testHosted2ResourceID", "testHosted2ResourceType");
        hostedResource2.setDescription(new TranslatableString("testHosted2Description", "testHosted2Key"));
        hostedResource2.setName("testHosted2Name");
        hostedResource2.setShortDescription(new TranslatableString("testHosted2ShortDescription", "testHosted2ShortKey"));
        Resource hostedResource3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testHosted3ResourceID", "testHosted3ResourceType");
        hostedResource3.setDescription(new TranslatableString("testHosted3Description", "testHosted3Key"));
        hostedResource3.setName("testHosted3Name");
        hostedResource3.setShortDescription(new TranslatableString("testHosted3ShortDescription", "testHosted3ShortKey"));
        hostedResource1.setHostedResources((Collection<Resource>)Arrays.asList(hostedResource3));
        this.resource.setHostedResources((Collection<Resource>)Arrays.asList(hostedResource1, hostedResource2));
        Properties properties = new Properties();
        properties.setProperty("testKey1", "testValue1");
        properties.setProperty("testKey2", "testValue2");
        this.resource.setProperties(properties);
        this.clonedResource = (Resource)this.resource.clone();
        this.element = ((SPIDataObject)((Object)this.resource)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetName() {
        Resource_Test.assertEquals((String)"testName", (String)this.resource.getName());
        Resource_Test.assertEquals((String)"testName", (String)this.clonedResource.getName());
        Resource_Test.assertEquals((String)"testName", (String)this.session.getChildren(this.element, "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetResourceID() {
        Resource_Test.assertEquals((String)"testResourceID", (String)this.resource.getResourceID());
        Resource_Test.assertEquals((String)"testResourceID", (String)this.clonedResource.getResourceID());
        Resource_Test.assertEquals((String)"testResourceID", (String)this.element.getAttribute("id"));
    }

    public void testGetResourceType() {
        Resource_Test.assertEquals((String)"testResourceType", (String)this.resource.getResourceType());
        Resource_Test.assertEquals((String)"testResourceType", (String)this.clonedResource.getResourceType());
        Resource_Test.assertEquals((String)"testResourceType", (String)this.element.getAttribute("type"));
    }

    public void testGetProperties() {
        Properties testProps = this.resource.getProperties();
        Properties testclonedProps = this.clonedResource.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        Resource_Test.assertEquals((Object)"testValue1", (Object)testProps.get("testKey1"));
        Resource_Test.assertEquals((Object)"testValue2", (Object)testProps.get("testKey2"));
        Resource_Test.assertEquals((Object)"testValue1", (Object)testclonedProps.get("testKey1"));
        Resource_Test.assertEquals((Object)"testValue2", (Object)testclonedProps.get("testKey2"));
        Resource_Test.assertEquals((int)2, (int)testDataObjectProps.size());
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            Resource_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            Resource_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            Resource_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testGetHostedResources() {
        Collection<Resource> testHostedResources = this.resource.getHostedResources();
        Collection<Resource> testClonedHostedResources = this.clonedResource.getHostedResources();
        Collection<Element> testDataObjectHostedResources = this.session.getChildren(this.element, "HostedResource");
        Resource_Test.assertEquals((int)2, (int)testHostedResources.size());
        Resource_Test.assertEquals((int)2, (int)testClonedHostedResources.size());
        Resource_Test.assertEquals((int)2, (int)testDataObjectHostedResources.size());
        Resource_Test.assertEquals((String)"testHosted1Description", (String)testHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted1Key", (String)testHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted1Name", (String)testHostedResources.toArray(new Resource[0])[0].getName());
        Resource_Test.assertEquals((String)"testHosted1ResourceID", (String)testHostedResources.toArray(new Resource[0])[0].getResourceID());
        Resource_Test.assertEquals((String)"testHosted1ResourceType", (String)testHostedResources.toArray(new Resource[0])[0].getResourceType());
        Resource_Test.assertEquals((String)"testHosted1ShortDescription", (String)testHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted1ShortKey", (String)testHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted2Description", (String)testHostedResources.toArray(new Resource[0])[1].getDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted2Key", (String)testHostedResources.toArray(new Resource[0])[1].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted2Name", (String)testHostedResources.toArray(new Resource[0])[1].getName());
        Resource_Test.assertEquals((String)"testHosted2ResourceID", (String)testHostedResources.toArray(new Resource[0])[1].getResourceID());
        Resource_Test.assertEquals((String)"testHosted2ResourceType", (String)testHostedResources.toArray(new Resource[0])[1].getResourceType());
        Resource_Test.assertEquals((String)"testHosted2ShortDescription", (String)testHostedResources.toArray(new Resource[0])[1].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted2ShortKey", (String)testHostedResources.toArray(new Resource[0])[1].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted1Description", (String)testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted1Key", (String)testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted1Name", (String)testClonedHostedResources.toArray(new Resource[0])[0].getName());
        Resource_Test.assertEquals((String)"testHosted1ResourceID", (String)testClonedHostedResources.toArray(new Resource[0])[0].getResourceID());
        Resource_Test.assertEquals((String)"testHosted1ResourceType", (String)testClonedHostedResources.toArray(new Resource[0])[0].getResourceType());
        Resource_Test.assertEquals((String)"testHosted1ShortDescription", (String)testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted1ShortKey", (String)testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted2Description", (String)testClonedHostedResources.toArray(new Resource[0])[1].getDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted2Key", (String)testClonedHostedResources.toArray(new Resource[0])[1].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted2Name", (String)testClonedHostedResources.toArray(new Resource[0])[1].getName());
        Resource_Test.assertEquals((String)"testHosted2ResourceID", (String)testClonedHostedResources.toArray(new Resource[0])[1].getResourceID());
        Resource_Test.assertEquals((String)"testHosted2ResourceType", (String)testClonedHostedResources.toArray(new Resource[0])[1].getResourceType());
        Resource_Test.assertEquals((String)"testHosted2ShortDescription", (String)testClonedHostedResources.toArray(new Resource[0])[1].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted2ShortKey", (String)testClonedHostedResources.toArray(new Resource[0])[1].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted1Description", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "Description").getTextContent());
        Resource_Test.assertEquals((String)"testHosted1Key", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "Description").getAttribute("translationKey"));
        Resource_Test.assertEquals((String)"testHosted1Name", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "Name").getTextContent());
        Resource_Test.assertEquals((String)"testHosted1ResourceID", (String)testDataObjectHostedResources.toArray(new Element[0])[0].getAttribute("id"));
        Resource_Test.assertEquals((String)"testHosted1ResourceType", (String)testDataObjectHostedResources.toArray(new Element[0])[0].getAttribute("type"));
        Resource_Test.assertEquals((String)"testHosted1ShortDescription", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "ShortDescription").getTextContent());
        Resource_Test.assertEquals((String)"testHosted1ShortKey", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "ShortDescription").getAttribute("translationKey"));
        Resource_Test.assertEquals((String)"testHosted2Description", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[1], "Description").getTextContent());
        Resource_Test.assertEquals((String)"testHosted2Key", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[1], "Description").getAttribute("translationKey"));
        Resource_Test.assertEquals((String)"testHosted2Name", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[1], "Name").getTextContent());
        Resource_Test.assertEquals((String)"testHosted2ResourceID", (String)testDataObjectHostedResources.toArray(new Element[0])[1].getAttribute("id"));
        Resource_Test.assertEquals((String)"testHosted2ResourceType", (String)testDataObjectHostedResources.toArray(new Element[0])[1].getAttribute("type"));
        Resource_Test.assertEquals((String)"testHosted2ShortDescription", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[1], "ShortDescription").getTextContent());
        Resource_Test.assertEquals((String)"testHosted2ShortKey", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[1], "ShortDescription").getAttribute("translationKey"));
        Collection<Resource> testHosted1Resources = testHostedResources.toArray(new Resource[0])[0].getHostedResources();
        Collection<Resource> testClonedHosted1Resources = testClonedHostedResources.toArray(new Resource[0])[0].getHostedResources();
        Collection<Element> testDataObjectHosted1Resources = this.session.getChildren(testDataObjectHostedResources.toArray(new Element[0])[0], "HostedResource");
        Resource_Test.assertEquals((int)1, (int)testHosted1Resources.size());
        Resource_Test.assertEquals((int)1, (int)testClonedHosted1Resources.size());
        Resource_Test.assertEquals((int)1, (int)testDataObjectHosted1Resources.size());
        Resource_Test.assertEquals((String)"testHosted3Description", (String)testHosted1Resources.toArray(new Resource[0])[0].getDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted3Key", (String)testHosted1Resources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted3Name", (String)testHosted1Resources.toArray(new Resource[0])[0].getName());
        Resource_Test.assertEquals((String)"testHosted3ResourceID", (String)testHosted1Resources.toArray(new Resource[0])[0].getResourceID());
        Resource_Test.assertEquals((String)"testHosted3ResourceType", (String)testHosted1Resources.toArray(new Resource[0])[0].getResourceType());
        Resource_Test.assertEquals((String)"testHosted3ShortDescription", (String)testHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted3ShortKey", (String)testHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted3Description", (String)testClonedHosted1Resources.toArray(new Resource[0])[0].getDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted3Key", (String)testClonedHosted1Resources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted3Name", (String)testClonedHosted1Resources.toArray(new Resource[0])[0].getName());
        Resource_Test.assertEquals((String)"testHosted3ResourceID", (String)testClonedHosted1Resources.toArray(new Resource[0])[0].getResourceID());
        Resource_Test.assertEquals((String)"testHosted3ResourceType", (String)testClonedHosted1Resources.toArray(new Resource[0])[0].getResourceType());
        Resource_Test.assertEquals((String)"testHosted3ShortDescription", (String)testClonedHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testHosted3ShortKey", (String)testClonedHosted1Resources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testHosted3Description", (String)this.session.getChild(testDataObjectHosted1Resources.toArray(new Element[0])[0], "Description").getTextContent());
        Resource_Test.assertEquals((String)"testHosted3Key", (String)this.session.getChild(testDataObjectHosted1Resources.toArray(new Element[0])[0], "Description").getAttribute("translationKey"));
        Resource_Test.assertEquals((String)"testHosted3Name", (String)this.session.getChild(testDataObjectHosted1Resources.toArray(new Element[0])[0], "Name").getTextContent());
        Resource_Test.assertEquals((String)"testHosted3ResourceID", (String)testDataObjectHosted1Resources.toArray(new Element[0])[0].getAttribute("id"));
        Resource_Test.assertEquals((String)"testHosted3ResourceType", (String)testDataObjectHosted1Resources.toArray(new Element[0])[0].getAttribute("type"));
        Resource_Test.assertEquals((String)"testHosted3ShortDescription", (String)this.session.getChild(testDataObjectHosted1Resources.toArray(new Element[0])[0], "ShortDescription").getTextContent());
        Resource_Test.assertEquals((String)"testHosted3ShortKey", (String)this.session.getChild(testDataObjectHosted1Resources.toArray(new Element[0])[0], "ShortDescription").getAttribute("translationKey"));
    }

    public void testGetDescription() {
        Resource_Test.assertEquals((String)"testDescription", (String)this.resource.getDescription().getValue());
        Resource_Test.assertEquals((String)"testKey", (String)this.resource.getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testDescription", (String)this.clonedResource.getDescription().getValue());
        Resource_Test.assertEquals((String)"testKey", (String)this.clonedResource.getDescription().getTranslationKey());
        Element descElement = this.session.getChildren(this.element, "Description").toArray(new Element[0])[0];
        Resource_Test.assertEquals((String)"testDescription", (String)descElement.getTextContent());
        Resource_Test.assertEquals((String)"testKey", (String)descElement.getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        Resource_Test.assertEquals((String)"testShortDescription", (String)this.resource.getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testShortKey", (String)this.resource.getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testShortDescription", (String)this.clonedResource.getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testShortKey", (String)this.clonedResource.getShortDescription().getTranslationKey());
        Element descElement = this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0];
        Resource_Test.assertEquals((String)"testShortDescription", (String)descElement.getTextContent());
        Resource_Test.assertEquals((String)"testShortKey", (String)descElement.getAttribute("translationKey"));
    }

    public void testGetTranslatableStrings() {
        Properties props = this.resource.getTranslatableStrings();
        Properties clonedProps = this.clonedResource.getTranslatableStrings();
        Resource_Test.assertEquals((int)8, (int)props.keySet().size());
        Resource_Test.assertEquals((int)8, (int)clonedProps.keySet().size());
        Resource_Test.assertEquals((Object)"testDescription", (Object)props.get("testKey"));
        Resource_Test.assertEquals((Object)"testShortDescription", (Object)props.get("testShortKey"));
        Resource_Test.assertEquals((Object)"testHosted1Description", (Object)props.get("testHosted1Key"));
        Resource_Test.assertEquals((Object)"testHosted1ShortDescription", (Object)props.get("testHosted1ShortKey"));
        Resource_Test.assertEquals((Object)"testHosted2Description", (Object)props.get("testHosted2Key"));
        Resource_Test.assertEquals((Object)"testHosted2ShortDescription", (Object)props.get("testHosted2ShortKey"));
        Resource_Test.assertEquals((Object)"testHosted3Description", (Object)props.get("testHosted3Key"));
        Resource_Test.assertEquals((Object)"testHosted3ShortDescription", (Object)props.get("testHosted3ShortKey"));
        Resource_Test.assertEquals((Object)"testDescription", (Object)clonedProps.get("testKey"));
        Resource_Test.assertEquals((Object)"testShortDescription", (Object)clonedProps.get("testShortKey"));
        Resource_Test.assertEquals((Object)"testHosted1Description", (Object)clonedProps.get("testHosted1Key"));
        Resource_Test.assertEquals((Object)"testHosted1ShortDescription", (Object)clonedProps.get("testHosted1ShortKey"));
        Resource_Test.assertEquals((Object)"testHosted2Description", (Object)clonedProps.get("testHosted2Key"));
        Resource_Test.assertEquals((Object)"testHosted2ShortDescription", (Object)clonedProps.get("testHosted2ShortKey"));
        Resource_Test.assertEquals((Object)"testHosted3Description", (Object)clonedProps.get("testHosted3Key"));
        Resource_Test.assertEquals((Object)"testHosted3ShortDescription", (Object)clonedProps.get("testHosted3ShortKey"));
    }

    public void testSetHostedResources() {
        Resource hostedResource = SPISession.DEFAULT_INSTANCE.createBaseFactory().createHostedResource("testDifferentHostedResourceID", "testDifferentHostedResourceType");
        hostedResource.setDescription(new TranslatableString("testDifferentHostedDescription", "testDifferentHostedKey"));
        hostedResource.setName("testDifferentHostedName");
        hostedResource.setShortDescription(new TranslatableString("testDifferentHostedShortDescription", "testDifferentHostedShortKey"));
        this.resource.setHostedResources((Collection<Resource>)Arrays.asList(hostedResource));
        Collection<Resource> testHostedResources = this.resource.getHostedResources();
        Collection<Resource> testClonedHostedResources = ((Resource)this.resource.clone()).getHostedResources();
        Collection<Element> testDataObjectHostedResources = this.session.getChildren(((SPIDataObject)((Object)this.resource)).getElement(), "HostedResource");
        Resource_Test.assertEquals((int)1, (int)testHostedResources.size());
        Resource_Test.assertEquals((int)1, (int)testClonedHostedResources.size());
        Resource_Test.assertEquals((int)1, (int)testDataObjectHostedResources.size());
        Resource_Test.assertEquals((String)"testDifferentHostedDescription", (String)testHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        Resource_Test.assertEquals((String)"testDifferentHostedKey", (String)testHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testDifferentHostedName", (String)testHostedResources.toArray(new Resource[0])[0].getName());
        Resource_Test.assertEquals((String)"testDifferentHostedResourceID", (String)testHostedResources.toArray(new Resource[0])[0].getResourceID());
        Resource_Test.assertEquals((String)"testDifferentHostedResourceType", (String)testHostedResources.toArray(new Resource[0])[0].getResourceType());
        Resource_Test.assertEquals((String)"testDifferentHostedShortDescription", (String)testHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testDifferentHostedShortKey", (String)testHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testDifferentHostedDescription", (String)testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getValue());
        Resource_Test.assertEquals((String)"testDifferentHostedKey", (String)testClonedHostedResources.toArray(new Resource[0])[0].getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testDifferentHostedName", (String)testClonedHostedResources.toArray(new Resource[0])[0].getName());
        Resource_Test.assertEquals((String)"testDifferentHostedResourceID", (String)testClonedHostedResources.toArray(new Resource[0])[0].getResourceID());
        Resource_Test.assertEquals((String)"testDifferentHostedResourceType", (String)testClonedHostedResources.toArray(new Resource[0])[0].getResourceType());
        Resource_Test.assertEquals((String)"testDifferentHostedShortDescription", (String)testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testDifferentHostedShortKey", (String)testClonedHostedResources.toArray(new Resource[0])[0].getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testDifferentHostedDescription", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "Description").getTextContent());
        Resource_Test.assertEquals((String)"testDifferentHostedKey", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "Description").getAttribute("translationKey"));
        Resource_Test.assertEquals((String)"testDifferentHostedName", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "Name").getTextContent());
        Resource_Test.assertEquals((String)"testDifferentHostedResourceID", (String)testDataObjectHostedResources.toArray(new Element[0])[0].getAttribute("id"));
        Resource_Test.assertEquals((String)"testDifferentHostedResourceType", (String)testDataObjectHostedResources.toArray(new Element[0])[0].getAttribute("type"));
        Resource_Test.assertEquals((String)"testDifferentHostedShortDescription", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "ShortDescription").getTextContent());
        Resource_Test.assertEquals((String)"testDifferentHostedShortKey", (String)this.session.getChild(testDataObjectHostedResources.toArray(new Element[0])[0], "ShortDescription").getAttribute("translationKey"));
    }

    public void testSetName() {
        this.resource.setName("testSetName");
        Resource_Test.assertEquals((String)"testSetName", (String)this.resource.getName());
        Resource_Test.assertEquals((String)"testSetName", (String)this.session.getChild(((SPIDataObject)((Object)this.resource)).getElement(), "Name").getTextContent());
    }

    public void testSetResourceID() {
        this.resource.setResourceID("testSetResourceID");
        Resource_Test.assertEquals((String)"testSetResourceID", (String)this.resource.getResourceID());
        Resource_Test.assertEquals((String)"testSetResourceID", (String)((SPIDataObject)((Object)this.resource)).getElement().getAttribute("id"));
        try {
            this.resource.setResourceID(null);
            Resource_Test.fail((String)"Null value was set for id");
        }
        catch (Exception exception) {}
    }

    public void testSetResourceType() {
        this.resource.setResourceType("testSetResourceType");
        Resource_Test.assertEquals((String)"testSetResourceType", (String)this.resource.getResourceType());
        Resource_Test.assertEquals((String)"testSetResourceType", (String)((SPIDataObject)((Object)this.resource)).getElement().getAttribute("type"));
        try {
            this.resource.setResourceType(null);
            Resource_Test.fail((String)"Null value was set for type");
        }
        catch (Exception exception) {}
    }

    public void testSetProperties() {
        Properties properties = new Properties();
        properties.setProperty("testSetPropertiesKey", "testSetPropertiesValue");
        this.resource.setProperties(properties);
        Properties testProps = this.resource.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        Resource_Test.assertEquals((Object)"testSetPropertiesValue", (Object)testProps.get("testSetPropertiesKey"));
        Resource_Test.assertEquals((int)1, (int)testDataObjectProps.size());
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            Resource_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            Resource_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            Resource_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testSetDescription() {
        this.resource.setDescription(new TranslatableString("testSetDescription", "testSetDescriptionKey"));
        Resource_Test.assertEquals((String)"testSetDescription", (String)this.resource.getDescription().getValue());
        Resource_Test.assertEquals((String)"testSetDescription", (String)this.session.getChild(((SPIDataObject)((Object)this.resource)).getElement(), "Description").getTextContent());
        Resource_Test.assertEquals((String)"testSetDescriptionKey", (String)this.resource.getDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testSetDescriptionKey", (String)this.session.getChild(((SPIDataObject)((Object)this.resource)).getElement(), "Description").getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.resource.setShortDescription(new TranslatableString("testSetShortDescription", "testSetShortDescriptionKey"));
        Resource_Test.assertEquals((String)"testSetShortDescription", (String)this.resource.getShortDescription().getValue());
        Resource_Test.assertEquals((String)"testSetShortDescription", (String)this.session.getChild(((SPIDataObject)((Object)this.resource)).getElement(), "ShortDescription").getTextContent());
        Resource_Test.assertEquals((String)"testSetShortDescriptionKey", (String)this.resource.getShortDescription().getTranslationKey());
        Resource_Test.assertEquals((String)"testSetShortDescriptionKey", (String)this.session.getChild(((SPIDataObject)((Object)this.resource)).getElement(), "ShortDescription").getAttribute("translationKey"));
    }
}

