/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * A version value includes a version and a list of required fixes associated with that version.
 */
public interface VersionValue {

	/**
	 * Gets the version.
	 * 
	 * A string containing a single, exact version value. This is compared with the version value of specific resource instances. 
	 * Only equal values satisfy this part of the constraint.
	 * 
	 * @return An allowable version value.
	 */
	String getVersion();
	
	/**
	 * Gets the fix names.
	 * 
	 * Any number of FixName elements can be defined, identifying fixes that must be discovered to be applied for the version 
	 * constraint to be considered met.
	 * 
	 * @return A collection of names of a fixes.
	 */
	Collection<String> getFixNames();
	
	/**
	 * Sets the version.
	 * 
	 * A string containing a single, exact version value. This is compared with the version value of specific resource instances. 
	 * Only equal values satisfy this part of the constraint.
	 * 
	 * @param version An allowable version value.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setVersion(String version);
	
	/**
	 * Sets the fix names.
	 * 
	 * Any number of FixName elements can be defined, identifying fixes that must be discovered to be applied for the version 
	 * constraint to be considered met.
	 * 
	 * @param fixNames A collection of names of a fixes.
	 */
	void setFixNames(Collection<String> fixNames);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
