/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;



/**
 * FeatureType provides the type definition for each feature defined directly below SelectableContent. 
 * A Feature can define NestedFeatures and identify ContentElements and other features that 
 * will be selected when the feature is selected. A feature can also be defined to be available 
 * for selection only under certain conditions.
 *
 */
public interface Feature extends NestedFeature {
    /**
     * Gets whether the feature is required.
     * 
     * A top level Feature MUST be selected when the value of the required attribute is true. In this case, the user cannot 
     * choose to deselect this top level Feature.<br><br>
     * In Features that define Multiplicity, the SDD author can state a minimum number of instances of the Feature. This minimum 
     * applies only if the Feature is selected. The required attribute can be used to indicate that the Feature is always selected 
     * and so the minimum number of instances applies.<br><br>
     * The required attribute SHOULD be used only when Multiplicity is applied to the Feature.
     * 
     * @return A boolean indicates the feature must be selected.
     */
    Boolean getRequired();
    
    /**
     * Sets whether the feature is required.
     * 
     * A top level Feature MUST be selected when the value of the required attribute is true. In this case, the user cannot 
     * choose to deselect this top level Feature.<br><br>
     * In Features that define Multiplicity, the SDD author can state a minimum number of instances of the Feature. This minimum 
     * applies only if the Feature is selected. The required attribute can be used to indicate that the Feature is always selected 
     * and so the minimum number of instances applies.<br><br>
     * The required attribute SHOULD be used only when Multiplicity is applied to the Feature.
     * 
     * @param required  A boolean indicates the feature must be selected.
     * <ul>**default value=false</ul>
     * 
     */
    void setRequired(Boolean required);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
