/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * Object is an optional element that may occur one or more times. When present, 
 * this element may contain any data. The Object element may include optional MIME type, 
 * ID, and encoding attributes.
 * 
 * The Object's Encoding attributed may be used to provide a URI that identifies the method 
 * by which the object is encoded (e.g., a binary file).
 *
 */
public interface SignatureObject {
	/**
	 * Gets the ID.
	 * 
	 * The Object's Id is commonly referenced from a Reference in SignedInfo, or Manifest. 
	 * This element is typically used for enveloping signatures where the object being signed 
	 * is to be included in the signature element. The digest is calculated over the entire Object  
	 * element including start and end tags.
	 * 
	 * @return ID
	 */
	String getId();
	
	/**
	 * Sets the ID.
	 * 
	 * The Object's Id is commonly referenced from a Reference in SignedInfo, or Manifest. 
	 * This element is typically used for enveloping signatures where the object being signed 
	 * is to be included in the signature element. The digest is calculated over the entire Object  
	 * element including start and end tags.
	 * 
	 * @param id A new ID.
	 */
	void setId(String id);
	
	/**
	 * Get the mime type.
	 * 
	 * The MimeType attribute is an optional attribute which describes the data within the Object  
	 * (independent of its encoding). This is a string with values defined by [MIME].
	 * 
	 * @return The mime type.
	 */
	String getMimeType();
	
	/**
	 * Sets the mime type.
	 * 
	 * The MimeType attribute is an optional attribute which describes the data within the Object  
	 * (independent of its encoding). This is a string with values defined by [MIME].
	 * 
	 * @param mimeType A new mime type.
	 */
	void setMimeType(String mimeType);
	
	/**
	 * Gets the encoding.
	 * 
	 * Applications which require normative type and encoding information for signature validation 
	 * should specify Transforms with well defined resulting types and/or encodings.
	 * 
	 * @return The encoding.
	 */
	String getEncoding();
	
	/**
	 * Sets the encoding.
	 * 
	 * Applications which require normative type and encoding information for signature validation 
	 * should specify Transforms with well defined resulting types and/or encodings.
	 * 
	 * @param encoding A new encoding.
	 */
	void setEncoding(String encoding);
}
