/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.logging.events.cbe.util;

import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.core.LoggingCoreUtilities;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.tptp.logging.events.cbe.CompletionException;
import org.eclipse.tptp.logging.events.cbe.ContentHandler;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.ExtendedDataElement;
import org.eclipse.tptp.logging.events.cbe.Situation;
import org.eclipse.tptp.logging.events.cbe.impl.TemplateContentHandlerImpl;

public class EventHelpers {
    private static boolean isJava14xRunTime = true;

    public static long dateToLong(String xsdDateTime) {
        return LoggingCoreUtilities.convertXsdDateTimeToMilliseconds((String)xsdDateTime);
    }

    public static String longToDate(long milliseconds) {
        return LoggingCoreUtilities.convertMillisecondsToXsdDateTime((long)milliseconds);
    }

    public static String getFormattedDateString(long milliseconds) throws IllegalArgumentException {
        return LoggingCoreUtilities.getFormattedDateString((long)milliseconds);
    }

    public static String getFormattedDateString(long milliseconds, String dateFormatPattern) throws IllegalArgumentException {
        return LoggingCoreUtilities.getFormattedDateString((long)milliseconds, (String)dateFormatPattern);
    }

    public static String getFormattedDateString(String xsdDateTime) throws IllegalArgumentException {
        return LoggingCoreUtilities.getFormattedDateString((String)xsdDateTime);
    }

    public static String getFormattedDateString(String xsdDateTime, String dateFormatPattern) throws IllegalArgumentException {
        return LoggingCoreUtilities.getFormattedDateString((String)xsdDateTime, (String)dateFormatPattern);
    }

    public static String getString(String key) {
        return LoggingCoreResourceBundle.getString((String)key);
    }

    public static String getString(String key, Object argument) {
        return LoggingCoreResourceBundle.getString((String)key, (Object)argument);
    }

    public static String getString(String key, Object argumentA, Object argumentB) {
        return LoggingCoreResourceBundle.getString((String)key, (Object)argumentA, (Object)argumentB);
    }

    public static String getString(String key, Object argumentA, Object argumentB, Object argumentC) {
        return LoggingCoreResourceBundle.getString((String)key, (Object)argumentA, (Object)argumentB, (Object)argumentC);
    }

    public static String getString(String key, Object argumentA, Object argumentB, Object argumentC, Object argumentD) {
        return LoggingCoreResourceBundle.getString((String)key, (Object)argumentA, (Object)argumentB, (Object)argumentC, (Object)argumentD);
    }

    public static String getString(String key, Object[] arguments) {
        return LoggingCoreResourceBundle.getString((String)key, (Object[])arguments);
    }

    public static ExtendedDataElement convertToExtendedDataElement(Throwable throwable) {
        return EventHelpers.convertToExtendedDataElement(throwable, "Throwable");
    }

    public static ExtendedDataElement convertToExtendedDataElement(Throwable throwable, String name) {
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        extendedDataElement.setName(name);
        extendedDataElement.setTypeAsInt(16);
        if (throwable == null) {
            extendedDataElement.setValues(new String[1]);
        } else {
            if (isJava14xRunTime) {
                try {
                    Object[] stackTraceElements = (Object[])throwable.getClass().getMethod("getStackTrace", null).invoke((Object)throwable, null);
                    if (stackTraceElements.length > 0) {
                        String[] throwableStringArray = EventHelpers.getExtendedDataElementValuesArray(throwable.toString());
                        String[] values = new String[throwableStringArray.length + stackTraceElements.length];
                        System.arraycopy(throwableStringArray, 0, values, 0, throwableStringArray.length);
                        int counter = 0;
                        while (counter < stackTraceElements.length) {
                            values[counter + throwableStringArray.length] = stackTraceElements[counter].toString();
                            ++counter;
                        }
                        extendedDataElement.setValues(values);
                    } else {
                        extendedDataElement.setValues(EventHelpers.getExtendedDataElementValuesArray(throwable.toString()));
                    }
                    Throwable cause = (Throwable)throwable.getClass().getMethod("getCause", null).invoke((Object)throwable, null);
                    if (cause != null) {
                        extendedDataElement.addChild(EventHelpers.convertToExtendedDataElement(cause, "Cause"));
                    }
                    return extendedDataElement;
                }
                catch (Throwable throwable2) {
                    isJava14xRunTime = false;
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(outputStream, true);
            throwable.printStackTrace(writer);
            if (!writer.checkError()) {
                String[] stackTraceElements = InternationalizationUtilities.tokenize((String)outputStream.toString().trim(), (String)Constants.LINE_SEPARATOR);
                if (stackTraceElements.length > 1) {
                    String[] throwableStringArray = EventHelpers.getExtendedDataElementValuesArray(stackTraceElements[0].trim());
                    String[] values = new String[throwableStringArray.length + stackTraceElements.length - 1];
                    System.arraycopy(throwableStringArray, 0, values, 0, throwableStringArray.length);
                    int counter = 1;
                    while (counter < stackTraceElements.length) {
                        values[counter + throwableStringArray.length - 1] = stackTraceElements[counter].trim().startsWith("at") ? stackTraceElements[counter].trim().substring(2).trim() : stackTraceElements[counter].trim();
                        ++counter;
                    }
                    extendedDataElement.setValues(values);
                } else {
                    extendedDataElement.setValues(EventHelpers.getExtendedDataElementValuesArray(stackTraceElements[0].trim()));
                }
            } else {
                extendedDataElement.setValues(EventHelpers.getExtendedDataElementValuesArray(throwable.toString()));
            }
            writer.close();
        }
        return extendedDataElement;
    }

    public static String[] getExtendedDataElementValuesArray(String values) {
        if (values == null) {
            return new String[1];
        }
        int valuesLength = values.length();
        if (valuesLength > 1024) {
            String[] valuesArray = new String[(int)Math.ceil((double)valuesLength / 1024.0)];
            int counter = 0;
            while (counter < valuesArray.length) {
                valuesArray[counter] = values.substring(counter * 1024, Math.min((counter + 1) * 1024, valuesLength));
                ++counter;
            }
            return valuesArray;
        }
        return new String[]{values};
    }

    public static boolean compareUnorderedLists(List listOne, List listTwo) {
        int listTwoSize = listTwo.size();
        if (listOne.size() != listTwoSize) {
            return false;
        }
        boolean[] listTwoMatches = new boolean[listTwoSize];
        Iterator listOneIterator = listOne.iterator();
        Object listOneElement = null;
        while (listOneIterator.hasNext()) {
            listOneElement = listOneIterator.next();
            int counter = 0;
            while (counter < listTwoSize) {
                if (!listTwoMatches[counter] && (listOneElement == null ? listTwo.get(counter) == null : listOneElement.equals(listTwo.get(counter)))) {
                    listTwoMatches[counter] = true;
                    break;
                }
                ++counter;
            }
            if (counter != listTwoSize) continue;
            return false;
        }
        return true;
    }

    public static CommonBaseEvent convertObjectToCommonBaseEvent(Object object, int maxReferences) {
        if (object instanceof CommonBaseEvent) {
            return (CommonBaseEvent)object;
        }
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        EventHelpers.convertObjectToCommonBaseEvent(commonBaseEvent, object, maxReferences);
        return commonBaseEvent;
    }

    public static void convertObjectToCommonBaseEvent(CommonBaseEvent commonBaseEvent, Object object, int maxReferences) {
        if (object instanceof CommonBaseEvent) {
            TemplateContentHandlerImpl templateContentHandler = new TemplateContentHandlerImpl();
            templateContentHandler.setTemplateEvent((CommonBaseEvent)object);
            ContentHandler currentContentHandler = commonBaseEvent.getContentHandler();
            commonBaseEvent.setContentHandler(templateContentHandler);
            try {
                commonBaseEvent.complete();
            }
            catch (CompletionException completionException) {}
            commonBaseEvent.setContentHandler(currentContentHandler);
        } else {
            if (commonBaseEvent.getGlobalInstanceId() == null) {
                commonBaseEvent.setGlobalInstanceId(EventFactory.eINSTANCE.createGlobalInstanceId());
            }
            if (!commonBaseEvent.isSetCreationTime()) {
                commonBaseEvent.setCreationTimeAsLong(System.currentTimeMillis());
            }
            if (commonBaseEvent.getSituation() == null) {
                Situation reportSituation = EventFactory.eINSTANCE.createSituation();
                reportSituation.setReportSituation("INTERNAL", "LOG");
                commonBaseEvent.setSituation(reportSituation);
            }
            if (commonBaseEvent.getSourceComponentId() == null) {
                commonBaseEvent.setSourceComponentId(null, "Logging", "Logger", "Logging_Application", "Application", Constants.LOCAL_HOST_IP_ADDRESS, "IPV4");
            }
            commonBaseEvent.addExtendedDataElement(EventHelpers.convertObjectToExtendedDataElement(object, null, maxReferences, 0));
        }
    }

    public static ExtendedDataElement convertObjectToExtendedDataElement(Object object, String instanceName, int maxReferences, int currentReferenceCount) {
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        if (object != null) {
            Class<?> objectsClass = object.getClass();
            if (EventHelpers.isSimpleType(object)) {
                String objectToString = object.toString().trim();
                int valuesLength = objectToString.length();
                if (valuesLength > 1024) {
                    ArrayList<String> valuesParts = new ArrayList<String>();
                    int counter = 0;
                    while (counter < valuesLength) {
                        valuesParts.add(objectToString.substring(counter, Math.min(counter + 1024, valuesLength)));
                        counter += 1024;
                    }
                    extendedDataElement.setValuesAsStringArray(valuesParts.toArray(new String[valuesParts.size()]));
                } else {
                    extendedDataElement.setValuesAsString(objectToString);
                }
            } else if (objectsClass.isArray()) {
                if (object instanceof boolean[]) {
                    boolean[] array = (boolean[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Boolean(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (object instanceof char[]) {
                    char[] array = (char[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Character(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (object instanceof byte[]) {
                    byte[] array = (byte[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Byte(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (object instanceof short[]) {
                    short[] array = (short[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Short(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (object instanceof int[]) {
                    int[] array = (int[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Integer(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (object instanceof long[]) {
                    long[] array = (long[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Long(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (object instanceof float[]) {
                    float[] array = (float[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Float(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (object instanceof double[]) {
                    double[] array = (double[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(new Double(array[counter]), null, maxReferences, currentReferenceCount));
                        ++counter;
                    }
                } else if (currentReferenceCount == maxReferences) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(instanceName));
                } else {
                    Object[] array = (Object[])object;
                    int counter = 0;
                    while (counter < array.length) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(array[counter], null, maxReferences, currentReferenceCount + 1));
                        ++counter;
                    }
                }
            } else if (object instanceof Collection) {
                if (currentReferenceCount == maxReferences) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(instanceName));
                } else {
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(iterator.next(), null, maxReferences, currentReferenceCount + 1));
                    }
                }
            } else if (object instanceof Enumeration) {
                if (currentReferenceCount == maxReferences) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(instanceName));
                } else {
                    Enumeration enumeration = (Enumeration)object;
                    while (enumeration.hasMoreElements()) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(enumeration.nextElement(), null, maxReferences, currentReferenceCount + 1));
                    }
                }
            } else if (object instanceof Iterator) {
                if (currentReferenceCount == maxReferences) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(instanceName));
                } else {
                    Iterator iterator = (Iterator)object;
                    while (iterator.hasNext()) {
                        extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(iterator.next(), null, maxReferences, currentReferenceCount + 1));
                    }
                }
            } else if (object instanceof Thread) {
                Thread thread = (Thread)object;
                extendedDataElement.addChild("Name", thread.getName());
                extendedDataElement.addChild("Priority", String.valueOf(thread.getPriority()));
                extendedDataElement.addChild("Group", thread.getThreadGroup().getName());
            } else if (object instanceof Throwable) {
                extendedDataElement = EventHelpers.convertToExtendedDataElement((Throwable)object);
            } else if (object instanceof Map) {
                if (currentReferenceCount == maxReferences) {
                    extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(instanceName));
                } else {
                    Map map = (Map)object;
                    Iterator keys = map.keySet().iterator();
                    ExtendedDataElement entryExtendedDataElement = null;
                    ExtendedDataElement keyExtendedDataElement = null;
                    ExtendedDataElement valueExtendedDataElement = null;
                    int counter = 1;
                    while (keys.hasNext()) {
                        Object key = keys.next();
                        entryExtendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
                        entryExtendedDataElement.setName("Entry_".concat(String.valueOf(counter++)));
                        entryExtendedDataElement.setTypeAsInt(0);
                        keyExtendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
                        keyExtendedDataElement.setName("Key");
                        keyExtendedDataElement.setTypeAsInt(0);
                        keyExtendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(key, null, maxReferences, currentReferenceCount + 1));
                        entryExtendedDataElement.addChild(keyExtendedDataElement);
                        valueExtendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
                        valueExtendedDataElement.setName("Value");
                        valueExtendedDataElement.setTypeAsInt(0);
                        valueExtendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(map.get(key), null, maxReferences, currentReferenceCount + 1));
                        entryExtendedDataElement.addChild(valueExtendedDataElement);
                        extendedDataElement.addChild(entryExtendedDataElement);
                    }
                }
            } else if (!(object instanceof EventQueue)) {
                if (object instanceof Class) {
                    Class theClass = (Class)object;
                    extendedDataElement.addChild("Name", EventHelpers.getClassName(theClass));
                    if (theClass.isPrimitive()) {
                        extendedDataElement.addChild("Type", "primitive");
                    } else if (theClass.isArray()) {
                        extendedDataElement.addChild("Type", "array");
                    } else if (theClass.isInterface()) {
                        extendedDataElement.addChild("Type", "interface");
                    } else {
                        extendedDataElement.addChild("Type", "class");
                    }
                    Package thePackage = theClass.getPackage();
                    if (thePackage != null) {
                        extendedDataElement.addChild("Package", thePackage.getName());
                    }
                    extendedDataElement.addChild("Modifers", Modifier.toString(theClass.getModifiers()));
                    extendedDataElement.addChild("Superclass", EventHelpers.getClassName(theClass.getSuperclass()));
                } else {
                    Method[] objectsMethods = objectsClass.getMethods();
                    String methodName = null;
                    Object returnObject = null;
                    int counter = 0;
                    while (counter < objectsMethods.length) {
                        methodName = objectsMethods[counter].getName().trim();
                        if (methodName.length() > 3 && methodName.startsWith("get") && objectsMethods[counter].getParameterTypes().length == 0) {
                            try {
                                returnObject = objectsMethods[counter].invoke(object, null);
                            }
                            catch (Throwable throwable) {
                                returnObject = null;
                            }
                            if (returnObject != null && !EventHelpers.isSimpleType(returnObject) && currentReferenceCount == maxReferences) {
                                extendedDataElement.addChild(EventHelpers.createEndOfNestingExtendedDataElement(methodName.substring(3)));
                            } else {
                                extendedDataElement.addChild(EventHelpers.convertObjectToExtendedDataElement(returnObject, methodName.substring(3), maxReferences, currentReferenceCount + 1));
                            }
                        }
                        ++counter;
                    }
                }
            }
        }
        extendedDataElement.setName(EventHelpers.getClassName(object));
        if (extendedDataElement.getType() == null) {
            extendedDataElement.setTypeAsInt(0);
        }
        if (instanceName != null && instanceName.trim().length() > 0) {
            extendedDataElement.addChild("Instance_Name", instanceName);
        }
        return extendedDataElement;
    }

    private static ExtendedDataElement createEndOfNestingExtendedDataElement(String instanceName) {
        ExtendedDataElement endExtendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        endExtendedDataElement.setName("End_Of_Nesting");
        endExtendedDataElement.setTypeAsInt(0);
        if (instanceName != null && instanceName.trim().length() > 0) {
            endExtendedDataElement.addChild("Instance_Name", instanceName);
        }
        return endExtendedDataElement;
    }

    private static String getClassName(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> theClass = object.getClass();
        String name = theClass.getName().trim();
        if (theClass.isArray()) {
            int index = name.lastIndexOf(91) + 1;
            String encodingString = name.substring(index).trim();
            char encoding = encodingString.charAt(0);
            String type = "";
            type = encoding == 'L' && encodingString.endsWith(";") ? encodingString.substring(1, encodingString.length() - 1) : (encoding == 'B' ? "byte" : (encoding == 'C' ? "char" : (encoding == 'D' ? "double" : (encoding == 'F' ? "float" : (encoding == 'I' ? "int" : (encoding == 'J' ? "long" : (encoding == 'S' ? "short" : (encoding == 'Z' ? "boolean" : encodingString.substring(1, encodingString.length())))))))));
            StringBuffer nameBuffer = new StringBuffer();
            nameBuffer.append(type);
            int depth = name.substring(0, index).trim().length();
            int counter = 0;
            while (counter < depth) {
                nameBuffer.append("[]");
                ++counter;
            }
            return nameBuffer.toString();
        }
        return name;
    }

    private static boolean isSimpleType(Object object) {
        return object.getClass().isPrimitive() || object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigDecimal || object instanceof BigInteger || object instanceof String || object instanceof StringBuffer;
    }
}

