/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.Layouts");
dojo.require("dojox.layout.FloatingPane");
dojo.require("dijit._Templated");
dojo.require("dijit.layout.ContentPane");

dojo.declare("org.eclipse.cosmos.provisional.dr.ps.components.widget.FloatingLayout", 
	dojox.layout.FloatingPane,
{
	templateString:"<div class=\"dojoxFloatingPane\" id=\"${id}\">\n\t<div tabindex=\"0\" waiRole=\"button\" class=\"dojoxFloatingPaneTitle\" dojoAttachPoint=\"focusNode\">\n\t\t<span dojoAttachPoint=\"maximizeWindowNode\" dojoAttachEvent=\"onclick: maximizeWindow\" class=\"maximizeWinIcon\"></span>\n\t\t<span dojoAttachPoint=\"restoreWindowNode\" dojoAttachEvent=\"onclick: restoreWindow\" class=\"hideWindowIcon\"></span>\n\t\t<span dojoAttachPoint=\"closeNode\" dojoAttachEvent=\"onclick: close\" class=\"dojoxFloatingCloseIcon\"></span>\n\t\t<span dojoAttachPoint=\"maxNode\" dojoAttachEvent=\"onclick: maximize\" class=\"dojoxFloatingMaximizeIcon\"></span>\n\t\t<span dojoAttachPoint=\"restoreNode\" dojoAttachEvent=\"onclick: _restore\" class=\"dojoxFloatingRestoreIcon\"></span>\t\n\t\t<span dojoAttachPoint=\"dockNode\" dojoAttachEvent=\"onclick: minimize\" class=\"dojoxFloatingMinimizeIcon\"></span>\n\t\t<span dojoAttachPoint=\"titleNode\" class=\"dijitInline dijitTitleNode\"></span>\n\t</div>\n\t<div dojoAttachPoint=\"canvas\" class=\"dojoxFloatingPaneCanvas\">\n\t\t<div dojoAttachPoint=\"containerNode\" waiRole=\"region\" tabindex=\"-1\" class=\"${contentClass}\">\n\t\t</div>\n\t\t<span dojoAttachPoint=\"resizeHandle\" class=\"dojoxFloatingResizeHandle\"></span>\n\t</div>\n</div>\n",
	offsetWidth:0,
	offsetHeight:0,
	oldTop:null,
	oldLeft:null,
	oldWidth:null,
	oldHeight:null,

	maximizeWindow: function(){
		this.oldTop = this.domNode.style.top;
		this.oldLeft = this.domNode.style.left;
		this.oldWidth = this.domNode.style.width;
		this.oldHeight = this.domNode.style.height;
		var windows = dojo.filter(
			this._allFPs,
			function(i){
				return i !== this;
			}, 
		this);
		dojo.forEach(windows, function(w, x){
			w.minimize();
		}, this);
		dojo.removeClass(this.maximizeWindowNode,"maximizeWinIcon");
		dojo.addClass(this.maximizeWindowNode,"hideWindowIcon");
		dojo.removeClass(this.restoreWindowNode,"hideWindowIcon");
		dojo.addClass(this.restoreWindowNode,"restoreWinIcon");
		dojo.removeClass(this.dockNode,"dojoxFloatingMinimizeIcon");
		dojo.addClass(this.dockNode,"hideWindowIcon");
		this.domNode.style.position ="absolute"; 
		this.domNode.style.left = "0"; 
		this.domNode.style.top = "0"; 

		this.maximize();

	},
	restoreWindow:function (){
		if(this._maximized == false){ return; }
		this.domNode.style.position ="relative"; 
		this._restore();
		dojo.removeClass(this.maximizeWindowNode,"hideWindowIcon");
		dojo.addClass(this.maximizeWindowNode,"maximizeWinIcon");
		dojo.removeClass(this.dockNode,"hideWindowIcon");
		dojo.addClass(this.dockNode,"dojoxFloatingMinimizeIcon");
		dojo.removeClass(this.restoreWindowNode,"restoreWinIcon");
		dojo.addClass(this.restoreWindowNode,"hideWindowIcon");

		this.domNode.style.position ="absolute"; 
		this.domNode.style.top = this.oldTop; 
		this.domNode.style.left = this.oldLeft; 
		this.domNode.style.width = this.oldWidth;
		this.domNode.style.height = this.oldHeight;

		var windows = dojo.filter(
			this._allFPs,
			function(i){
				return i !== this;
			}, 
		this);
		dojo.forEach(windows, function(w, x){
			w.show();
		}, this);

	},
	maximize: function(){
		// summary: Make this floatingpane fullscreen (viewport)	
		if(this._maximized){ return; }
		this._naturalState = dojo.coords(this.domNode);
		if(this._isDocked){
			this.show();
			setTimeout(dojo.hitch(this,"maximize"),this.duration);
		}
		dojo.addClass(this.focusNode,"floatingPaneMaximized");
		var viewPort = dijit.getViewport();
		viewPort.w = viewPort.w-this.offsetWidth;
		viewPort.h = viewPort.h-this.offsetHeight;
		this.resize(viewPort);
		this._maximized = true;
	}
});

	dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.widget.MinMaxLayout",
		[dijit.layout.ContentPane, dijit._Templated],
	{
		title: "",
		widthAddjust: 10,
		heightAdjust: 10,
		relativeHeight: -1,
		relativeHeightOffsetPx: 0,
		minimize: true,
		baseClass: "dijitTitlePane",
		templateString:"<div class=\"dijitTitlePane\">\n\t<div dojoAttachEvent=\"onfocus:_handleFocus,onblur:_handleFocus\" tabindex=\"0\"\n\t\t\twaiRole=\"button\" class=\"dijitTitlePaneTitle\" dojoAttachPoint=\"focusNode\">\n\t\t<span dojoAttachPoint=\"maximizeWindowNode\" dojoAttachEvent=\"onclick: maximizeWindow\" class=\"maximizeWinIcon\"></span>\n\t\t<span dojoAttachPoint=\"restoreWindowNode\" dojoAttachEvent=\"onclick: restoreWindow\" class=\"hideWindowIcon\"></span>\n\t\t<div dojoAttachPoint=\"titleNode\" class=\"dijitTitlePaneTextNode\"></div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" =\"hideNode\">\n\t\t<div class=\"dijitReset\" dojoAttachPoint=\"wipeNode\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" dojoAttachPoint=\"containerNode\" waiRole=\"region\" tabindex=\"-1\"></div>\n\t\t</div>\n\t</div>\n</div>\n",
		_allMinMax:[],
		postCreate: function(){
			this.setTitle(this.title);
			dojo.setSelectable(this.titleNode, false);
			this.inherited("postCreate",arguments);
			this._allMinMax.push(this);
			//need to adjust based on relativeHeight
			var viewPort = dijit.getViewport();
			this.oldLeft = this.domNode.style.left;
			this.oldTop = this.domNode.style.top;
			this.oldWidth = dojo.marginBox(this.domNode).w;
			this.oldHeight = dojo.marginBox(this.domNode).h;
			if (this.relativeHeight >=0){
				this.oldHeight = viewPort.h*this.relativeHeight/100-this.relativeHeightOffsetPx;
				this.resize({w: this.oldWidth, h: this.oldHeight});
				dojo.marginBox(this.containerNode, {w: (this.oldWidth-12), h: (this.oldHeight-27)});
			}
			

		},
		_handleFocus: function(/*Event*/ e){
			// summary: handle blur and focus for this widget
			
			// add/removeClass is safe to call without hasClass in this case
			dojo[(e.type=="focus" ? "addClass" : "removeClass")](this.focusNode,this.baseClass+"Focused");
		},

		setTitle: function(/*String*/ title){
			// summary: sets the text of the title
			this.titleNode.innerHTML=title;
		},

		maximizeWindow: function(){
			var windows = dojo.filter(
				this._allMinMax,
				function(i){
					return i !== this;
				}, 
			this);
			dojo.forEach(windows, function(w, x){
				w.domNode.style.visibility="hidden";
			}, this);
			dojo.removeClass(this.maximizeWindowNode,"maximizeWinIcon");
			dojo.addClass(this.maximizeWindowNode,"hideWindowIcon");
			dojo.removeClass(this.restoreWindowNode,"hideWindowIcon");
			dojo.addClass(this.restoreWindowNode,"restoreWinIcon");
			this.domNode.style.position ="absolute";
			
			this.domNode.style.left = "0"; 
			this.domNode.style.top = "0"; 

			this.maximize();

		},
		restoreWindow:function (){
			if(this._maximized == false){ return; }
			this.domNode.style.position ="relative"; 

			this.domNode.style.left = this.oldLeft;
			this.domNode.style.top = this.oldTop;
			this.resize({w: this.oldWidth, h: this.oldHeight});
			
			
			dojo.removeClass(this.maximizeWindowNode,"hideWindowIcon");
			dojo.addClass(this.maximizeWindowNode,"maximizeWinIcon");
			dojo.removeClass(this.restoreWindowNode,"restoreWinIcon");
			dojo.addClass(this.restoreWindowNode,"hideWindowIcon");

			var windows = dojo.filter(
				this._allMinMax,
				function(i){
					return i !== this;
				}, 
			this);
			dojo.forEach(windows, function(w, x){
				w.domNode.style.visibility="visible";
			}, this);

		},
		maximize: function(){
			// summary: Make this floatingpane fullscreen (viewport)	
			var viewPort = dijit.getViewport();
			var newWidth = viewPort.w-this.widthAddjust;
			this.resize({w: newWidth+"", h: (viewPort.h-this.heightAdjust)+""});
		}
				
	});
