/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.w3c.dom.Node;


/**
 * This simple property supports the following types:
 * <ul>
 *  <li> boolean </li>
 *  <li> integer </li>
 *  <li> double </li>
 * </ul>
 * 
 * 
 * @author Ali Mehregani
 */
public class SimpleTypeProperty extends BaseProperty
{
	/**
	 * Set if this simple type represents a boolean simple type 
	 */
	private boolean booleanValue;
		
	/**
	 * Set if this simple type represents an integer simple type 
	 */
	private int intValue;
	
	/**
	 * Set if this simple type represents a double simple type 
	 */
	private double doubleValue;
	
	/**
	 * The type of this property
	 */
	private int type;
	
	public SimpleTypeProperty(Node node, boolean value)
	{
		super(node.getNamespaceURI(), node.getLocalName());
		this.booleanValue = value;
		this.type = IProperty.BOOLEAN;
	}
	
	public SimpleTypeProperty(Node node, int value)
	{
		super(node.getNamespaceURI(), node.getLocalName());
		this.intValue = value;
		this.type = IProperty.INTEGER;
	}
	
	public SimpleTypeProperty(Node node, double value)
	{
		super(node.getNamespaceURI(), node.getLocalName());
		this.doubleValue = value;
		this.type = IProperty.DOUBLE;		
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.BaseProperty#equals(java.lang.Object, boolean)
	 */
	public boolean equals(Object o, boolean caseSensitive) throws CMDBfServiceException
	{		
		return operation (o, IOperator.EQUALS);
	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.BaseProperty#greater(java.lang.Object)
	 */
	public boolean greater(Object o) throws CMDBfServiceException
	{
		return operation (o, IOperator.GREATER_THAN);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.BaseProperty#less(java.lang.Object)
	 */
	public boolean less(Object o) throws CMDBfServiceException
	{		
		return operation (o, IOperator.LESS_THAN);
	}

	/**
	 * @param o
	 * @param operation
	 * @return
	 */
	public boolean operation (Object o, int operation) throws CMDBfServiceException
	{
		if (o == null)
		{
			return false;
		}		
		
		switch (type)
		{
			case IProperty.INTEGER:
			{									
				try
				{
					int operand = Integer.parseInt(o.toString());
					return operation == IOperator.EQUALS ? intValue == operand :
						   operation == IOperator.GREATER_THAN ? intValue > operand :
						   operation == IOperator.LESS_THAN ? intValue < operand :
						   false;

				}
				catch (NumberFormatException nfe)
				{
					throw propertyTypeMismatch();
				}
				
			}
			case IProperty.DOUBLE:
			{
				try
				{
					double operand = Double.parseDouble(o.toString());
					return operation == IOperator.EQUALS ? doubleValue == operand :
						   operation == IOperator.GREATER_THAN ? doubleValue > operand :
						   operation == IOperator.LESS_THAN ? doubleValue < operand :
						   false;
				}
				catch (NumberFormatException nfe)
				{
					throw propertyTypeMismatch();
				} 
			}
			case IProperty.BOOLEAN:
			{
				String str = o.toString();
				if (str == null || (!str.equalsIgnoreCase("true") && !str.equalsIgnoreCase("false")))
				{
					throw propertyTypeMismatch();
				}							
				boolean operand = Boolean.parseBoolean(o.toString());
				return operation == IOperator.EQUALS ? booleanValue == operand :						   
					   false;
				
			}
		}
		
		return false;
	}
}
