/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget");


 dojo.declare(
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog",
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
		xmlFormatString: null,
		titleDetailsViewer:"",	
		dialogIcon:"<span class='dialogRecordDetailsWinIcon'></span>",
		_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
		//templaltePath: String
		// url path to the html template that describes the dialog box
		templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/RecordDetailsDialog.html"),
		//widgetsInTemplate:boolean
		// determines if the html template contains dojo widgets
		widgetsInTemplate: true,
		minHeight: 690,
		//dialogTitle: String
		dialogTitle: "",
		//widgetId: String
		// unique id that identifies this instance.
		widgetId: "RecordDetailsDialog",
		
		create: function(params, srcNodeRef) {
		    
		//summary: inherited class from dijit._Widget
			//for some reason I need to destroy widget explicitly
   			if (dijit.byId(this.widgetId) != null)
   				dijit.byId(this.widgetId).destroy();
   			//change height based on view port and add 30 px padding
   			var newHeight = (dijit.getViewport().h-30);
   			if (newHeight > this.minHeight)
   				newHeight = this.minHeight;
			params.conheight = newHeight+"px";
			
			this.cancelLbl=this._message.OK;
			this.submitLbl=this._message.SUBMIT;	
			this.titleDetailsViewer=this._message.DETAILSVIEW + params.dialogTitle;
			this.okLbl=this._message.OK;
			org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog.superclass.create.apply(this, arguments);
		},			
		show: function(){
		//summary: displays the dialog box on the screen
			this.dialogBox.show();
		},
		onCancel: function(){
		//summary: this method is executed when the user clicks on the 'Cancel' button
			this.dialogBox.onCancel();
			this.destroy();
		},
		quit: function(){
		//summary: this method is executed when the user clicks on the 'Quit' button
			this.dialogBox.onCancel();
			this.destroy();
		},
		destroy:function(){
		//summary: destroys this widget
			if (this.dialogBox){
				this.dialogBox.onCancel();
			}
			this.inherited(arguments);
		},
		addItem: function(item){
		},
		postCreate: function(){
		//summary: inherited class from dijit._Widget
			org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog.superclass.postCreate.apply(this, arguments);
			this.dialogBox = dijit.byId(this.widgetId);
			dojo.connect(this.dialogBox.closeButtonNode,"onclick", this, "destroy");
		}
		
	}
);
 