/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.reference;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileDocument;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.w3c.dom.Node;

public class SMLDocumentReference
extends URIReference {
    private ISMLRepository repository;

    public SMLDocumentReference(ISMLRepository repositor, String reference) throws URISyntaxException {
        super(null, reference);
        this.repository = repositor;
    }

    public Node retrieveDocumentDOM() throws URISyntaxException {
        String document = this.getDocumentReference();
        String scheme = this.getReference().getScheme();
        if (scheme == null) {
            try {
                ISMLDocument[] documents = this.repository.fetchDocuments(new SMLFileMetadata(null, -1, null, new String[]{document}, null));
                if (documents == null || documents.length <= 0) {
                    documents = this.repository.fetchDocuments(new SMLFileMetadata(document, -1, null, null, null));
                }
                return documents.length == 1 && documents[0] instanceof SMLFileDocument ? ((SMLFileDocument)documents[0]).getDOMDocument() : null;
            }
            catch (RepositoryOperationException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return SMLValidatorUtil.retrieveRemoteDocument((String)this.getReference().toString());
        }
        catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
            return null;
        }
    }

    public URI getBase() {
        return super.getBase();
    }

    public void setBase(URI base) throws URISyntaxException {
        super.setBase(base);
    }
}

