/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.ContentType;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.SDDContentPurposeType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionModel;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.eclipse.cosmos.me.sdd.schema.ext.Variable;
import org.eclipse.cosmos.me.sdd.schema.ext.Variables;
import org.eclipse.cosmos.me.sdd.schema.marshal.Marshaller;
import org.eclipse.cosmos.me.sdd.schema.marshal.MarshallerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SddContextImpl
implements SDDContext {
    private static Pattern pattern = Pattern.compile("\\$\\([a-zA-Z_]+[0-9a-zA-Z_]*\\)");
    private static Pattern winpattern = Pattern.compile("\\%[a-zA-Z_]+[0-9a-zA-Z_]*%");
    private static Pattern unxpattern = Pattern.compile("\\$\\{[a-zA-Z_]+[0-9a-zA-Z_]*\\}");
    private Marshaller marshaller;
    private PackageDescriptorType packageDescriptor;
    private String pdParentUri;
    private DeploymentDescriptorType deploymentDescriptor;
    private Variables variables = new Variables();
    private ResolutionModel model = new ResolutionModel();
    LinkedHashMap<String, Object> parameters = new LinkedHashMap();

    public SddContextImpl(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public SddContextImpl(Marshaller marshaller, String packageUri) {
        this(marshaller);
        this.setPackageDescriptor(packageUri);
    }

    public PackageDescriptorType getPackageDescriptor() {
        return this.packageDescriptor;
    }

    public void setPackageDescriptor(String packageUri) {
        this.packageDescriptor = this.loadPackageDescriptor(packageUri);
        this.pdParentUri = this.getPackageDescriptorParent(packageUri);
        this.loadResponseFiles();
        this.deploymentDescriptor = this.loadDeploymentDescriptor(this.packageDescriptor, this.pdParentUri);
    }

    public String getPackageDescriptorParentUri() {
        return this.pdParentUri;
    }

    public DeploymentDescriptorType getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getVariable(String variable) {
        Matcher matcher = pattern.matcher(variable);
        while (matcher.find()) {
            variable = variable.substring(matcher.start() + 2, matcher.end() - 1);
        }
        for (Variable v : this.variables.getVariable()) {
            if (!v.getId().equals(variable)) continue;
            if (v.getValue() != null) {
                return v.getValue();
            }
            if (v.getDefaultValue() == null) continue;
            return v.getDefaultValue();
        }
        return "";
    }

    public void setVariable(String variable, String value) {
        Variable v2;
        for (Variable v2 : this.variables.getVariable()) {
            if (!v2.getId().equals(variable)) continue;
            v2.setValue(value);
            return;
        }
        v2 = new Variable(variable, value);
        this.variables.getVariable().add(v2);
    }

    public boolean containsVariable(String variable) {
        for (Variable v : this.variables.getVariable()) {
            if (!v.getId().equals(variable)) continue;
            return true;
        }
        return false;
    }

    public String substituteVariables(String expression) {
        String variable;
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            variable = expression.substring(matcher.start() + 2, matcher.end() - 1);
            expression = expression.replace(expression.substring(matcher.start(), matcher.end()), this.getVariable(variable));
            matcher = pattern.matcher(expression);
        }
        matcher = winpattern.matcher(expression);
        while (matcher.find()) {
            variable = expression.substring(matcher.start() + 1, matcher.end() - 1);
            expression = expression.replace(expression.substring(matcher.start(), matcher.end()), System.getenv(variable));
            matcher = pattern.matcher(expression);
        }
        matcher = unxpattern.matcher(expression);
        while (matcher.find()) {
            variable = expression.substring(matcher.start() + 2, matcher.end() - 1);
            expression = expression.replace(expression.substring(matcher.start(), matcher.end()), System.getenv(variable));
            matcher = pattern.matcher(expression);
        }
        return expression;
    }

    public ContentType getContentById(String id) {
        for (ContentType content : this.packageDescriptor.getContents().getContent()) {
            if (!content.getId().equals(id)) continue;
            return content;
        }
        return null;
    }

    public List<ContentType> getContentByPurpose(String purpose) {
        ArrayList<ContentType> result = new ArrayList<ContentType>();
        if (this.packageDescriptor != null && purpose != null) {
            for (ContentType content : this.packageDescriptor.getContents().getContent()) {
                if (!purpose.equals(content.getPurpose())) continue;
                result.add(content);
            }
        }
        return result;
    }

    public InputStream getInputStreamForPath(String path) {
        String substitutedPath = this.substituteVariables(path);
        try {
            File f = new File(substitutedPath);
            if (f.canRead()) {
                return new FileInputStream(f);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        String pathRelativeToPD = String.valueOf(this.getPackageDescriptorParentUri()) + File.separator + substitutedPath;
        try {
            File f = new File(pathRelativeToPD);
            if (f.canRead()) {
                return new FileInputStream(f);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return null;
    }

    public ResolutionModel getResolutionModel() {
        return this.model;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public void setParameter(String id, Boolean required, String defaultValue) {
        Variable v = new Variable(id, null);
        v.setParameter(Boolean.valueOf(true));
        if (required != null) {
            v.setRequired(required);
        }
        if (defaultValue != null) {
            v.setDefaultValue(defaultValue);
        }
        this.variables.getVariable().add(v);
    }

    private String getPackageDescriptorParent(String path) {
        if (path != null) {
            try {
                File dir = new File(path).getParentFile();
                if (dir.isDirectory()) {
                    return dir.getCanonicalPath();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private PackageDescriptorType loadPackageDescriptor(String path) {
        if (path != null) {
            try {
                return (PackageDescriptorType)this.marshaller.unmarshal(PackageDescriptorType.class, path);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private DeploymentDescriptorType loadDeploymentDescriptor(PackageDescriptorType pd, String path) {
        if (pd != null && path != null) {
            String dd = SDDContentPurposeType.DEPLOYMENT_DESCRIPTOR.value();
            ContentType ddContent = null;
            for (ContentType ct : pd.getContents().getContent()) {
                if (!dd.equals(ct.getPurpose())) continue;
                ddContent = ct;
                break;
            }
            if (ddContent != null) {
                String ddPath = String.valueOf(path) + File.separator + ddContent.getPathname();
                return this.loadDeploymentDescriptor(ddPath);
            }
        }
        return null;
    }

    private DeploymentDescriptorType loadDeploymentDescriptor(String path) {
        if (path != null) {
            try {
                return (DeploymentDescriptorType)this.marshaller.unmarshal(DeploymentDescriptorType.class, path);
            }
            catch (MarshallerException marshallerException) {}
        }
        return null;
    }

    private void loadResponseFiles() {
        List<ContentType> responseFiles = this.getContentByPurpose(SDDContentPurposeType.RESPONSE_FILE.value());
        for (ContentType responseFile : responseFiles) {
            InputStream stream = this.getInputStreamForPath(responseFile.getPathname());
            if (stream == null) continue;
            Properties props = new Properties();
            try {
                props.load(stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Object key : props.keySet()) {
                String variable = (String)key;
                String value = (String)props.get(key);
                this.setVariable(variable, value);
            }
        }
    }

    public boolean containsParameter(String parameterId) {
        return this.parameters.containsKey(parameterId);
    }

    public void setParameter(StringParameterType type, String id, Boolean required, String defaultValue) {
        this.setParameter(id, required, defaultValue);
        this.parameters.put(id, type);
    }

    public void setParameter(IntegerParameterType type, String id, Boolean required, String defaultValue) {
        this.setParameter(id, required, defaultValue);
        this.parameters.put(id, type);
    }

    public void setParameter(BooleanParameterType type, String id, Boolean required, String defaultValue) {
        this.setParameter(id, required, defaultValue);
        this.parameters.put(id, type);
    }

    public void setParameter(URIParameterType type, String id, Boolean required, String defaultValue) {
        this.setParameter(id, required, defaultValue);
        this.parameters.put(id, type);
    }

    public LinkedHashMap<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }
}

