/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.schema.ext;

public class ResolutionObject {

	private String _id = "";
	private String _referenceId = "";
	private Status _status = Status.unresolved;
	private String _value;
	
	public void unresolve() {
		_status = Status.unresolved;
	}
	
	public void resolve() {
		_status = Status.resolved;
	}
	
	public void accept() {
		_status = Status.accepted;
	}
	
	public void reject() {
		_status = Status.rejected;
	}
	
	public boolean isResolved() {
		return (_status == Status.resolved);
	}
	public boolean isUnresolved() {
		return (_status == Status.unresolved);
	}
	public boolean isAccepted() {
		return (_status == Status.accepted);
	}
	public boolean isRejected() {
		return (_status == Status.rejected);
	}
	
	public void setId(String id) {
		_id = id;
	}
	
	public String getId() {
		return _id;
	}

	public void setReferenceId(String referenceId) {
		_referenceId = referenceId;
	}
	
	public String getReferenceId() {
		return _referenceId;
	}

	public String getValue() {
		return _value;
	}
	
	public void setValue(String value) {
		_value = value;
	}
	
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("id=" + _id).append("\n");
		buffer.append("referenceId=" + _referenceId).append("\n");
		buffer.append("status=" + _status).append("\n");
		buffer.append("value=" + _value).append("\n");

		return buffer.toString();
	}
	
	private static enum Status {
		resolved, unresolved, accepted, rejected
	}
}
