/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.math.BigInteger;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.xmldsig.DigestMethodImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.DigestMethod;
import org.w3c.dom.Element;

public class PackageContentImpl
extends SPIDataObject
implements PackageContent,
Cloneable {
    private static final String PACKAGE_CONTENT_TYPE = "sdd-pd:ContentType";

    public PackageContentImpl(Element data, SPISessionImpl session) {
        super(data, session, PACKAGE_CONTENT_TYPE);
    }

    public String getContentID() {
        return this.getAttribute("id");
    }

    public String getContentPurpose() {
        return this.getAttribute("purpose");
    }

    public String getPathname() {
        return this.getAttribute("pathname");
    }

    public String getCharEncoding() {
        return this.getAttribute("charEncoding");
    }

    public BigInteger getLength() {
        if (this.isSetAttribute("length")) {
            String lengthString = this.getAttribute("length");
            return new BigInteger(lengthString);
        }
        return null;
    }

    public DigestMethod getDigestMethod() {
        DigestMethodImpl digestMethod = null;
        if (this.isSetElement("DigestMethod")) {
            digestMethod = new DigestMethodImpl(this.getChild("DigestMethod"), this.session);
        }
        return digestMethod;
    }

    public byte[] getDigestValue() {
        byte[] digestValue = null;
        if (this.isSetElement("DigestValue")) {
            digestValue = this.getChild("DigestValue").getTextContent().getBytes();
        }
        return digestValue;
    }

    public void setContentID(String contentID) {
        this.session.testParameter(contentID, 1, null);
        this.setAttribute("id", contentID);
    }

    public void setContentPurpose(String contentPurpose) {
        this.setAttribute("purpose", contentPurpose);
    }

    public void setPathname(String pathname) {
        this.session.testParameter(pathname, 1, null);
        this.setAttribute("pathname", pathname);
    }

    public void setCharEncoding(String charEncoding) {
        this.setAttribute("charEncoding", charEncoding);
    }

    public void setLength(BigInteger length) {
        if (length != null) {
            String lengthString = length.toString();
            this.setAttribute("length", lengthString);
        } else {
            this.unSetAttribute("length");
        }
    }

    public void setDigest(DigestMethod digestMethod, byte[] digestValue) {
        if (digestMethod == null && digestValue != null) {
            this.session.testParameter(digestMethod, 1, null);
        }
        if (digestMethod != null && digestValue == null) {
            this.session.testParameter(digestValue, 2, null);
        }
        if (digestMethod == null) {
            this.unSetElement("DigestMethod");
        } else {
            this.setContent((SPIDataObject)((Object)digestMethod));
        }
        if (digestValue == null) {
            this.unSetElement("DigestValue");
        } else {
            Element digestValueElement = this.session.createXmlDsigElement("DigestValue");
            digestValueElement.setTextContent(new String(digestValue));
            this.setContent(digestValueElement);
        }
    }

    public Object clone() {
        return new PackageContentImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    public String toString() {
        String description = new String("ContentID: " + this.getContentID() + " - Pathname: \"" + this.getPathname() + "\"");
        String contentPurpose = this.getContentPurpose();
        BigInteger length = this.getLength();
        if (contentPurpose != null) {
            description = String.valueOf(description) + " - Purpose: " + contentPurpose;
        }
        if (length != null) {
            description = String.valueOf(description) + " - Length: " + length;
        }
        description = String.valueOf(description) + "\n";
        return description;
    }
}

