/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.w3c.dom.Element;

public class Group_Test
extends TestCase {
    Group group;
    Group clonedGroup;
    Element element;
    SPISessionImpl session;

    public Group_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.group = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createGroup("groupID", (Collection<String>)Arrays.asList("feature1", "feature2"));
        this.group.setDefault(Boolean.TRUE);
        this.group.setDisplayName(new TranslatableString("displayName", "displayNameKey"));
        this.group.setDescription(new TranslatableString("desc", "descKey"));
        this.group.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        this.clonedGroup = (Group)this.group.clone();
        this.element = ((SPIDataObject)((Object)this.group)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = this.group.getTranslatableStrings();
        Properties clonedProps = this.clonedGroup.getTranslatableStrings();
        Group_Test.assertEquals((int)3, (int)props.keySet().size());
        Group_Test.assertEquals((int)3, (int)clonedProps.keySet().size());
        Group_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        Group_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        Group_Test.assertEquals((Object)"displayName", (Object)props.get("displayNameKey"));
        Group_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
        Group_Test.assertEquals((Object)"shortDesc", (Object)clonedProps.get("shortDescKey"));
        Group_Test.assertEquals((Object)"displayName", (Object)clonedProps.get("displayNameKey"));
    }

    public void testGetDefault() {
        Group_Test.assertTrue((boolean)this.group.getDefault());
        Group_Test.assertTrue((boolean)this.clonedGroup.getDefault());
        Group_Test.assertTrue((boolean)Boolean.parseBoolean(this.element.getAttribute("default")));
    }

    public void testGetGroupID() {
        Group_Test.assertEquals((String)"groupID", (String)this.group.getGroupID());
        Group_Test.assertEquals((String)"groupID", (String)this.clonedGroup.getGroupID());
        Group_Test.assertEquals((String)"groupID", (String)this.element.getAttribute("id"));
    }

    public void testGetSelectedFeatures() {
        Group_Test.assertEquals((int)2, (int)this.group.getSelectedFeatures().size());
        Group_Test.assertEquals((String)"feature1", (String)this.group.getSelectedFeatures().toArray(new String[0])[0]);
        Group_Test.assertEquals((String)"feature2", (String)this.group.getSelectedFeatures().toArray(new String[0])[1]);
        Group_Test.assertEquals((int)2, (int)this.clonedGroup.getSelectedFeatures().size());
        Group_Test.assertEquals((String)"feature1", (String)this.clonedGroup.getSelectedFeatures().toArray(new String[0])[0]);
        Group_Test.assertEquals((String)"feature2", (String)this.clonedGroup.getSelectedFeatures().toArray(new String[0])[1]);
        Group_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "SelectedFeature").size());
        Group_Test.assertEquals((String)"feature1", (String)this.session.getChildren(this.element, "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        Group_Test.assertEquals((String)"feature2", (String)this.session.getChildren(this.element, "SelectedFeature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetDisplayName() {
        Group_Test.assertEquals((String)"displayName", (String)this.group.getDisplayName().getValue());
        Group_Test.assertEquals((String)"displayNameKey", (String)this.group.getDisplayName().getTranslationKey());
        Group_Test.assertEquals((String)"displayName", (String)this.clonedGroup.getDisplayName().getValue());
        Group_Test.assertEquals((String)"displayNameKey", (String)this.clonedGroup.getDisplayName().getTranslationKey());
        Group_Test.assertEquals((String)"displayName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        Group_Test.assertEquals((String)"displayNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDescription() {
        Group_Test.assertEquals((String)"desc", (String)this.group.getDescription().getValue());
        Group_Test.assertEquals((String)"descKey", (String)this.group.getDescription().getTranslationKey());
        Group_Test.assertEquals((String)"desc", (String)this.clonedGroup.getDescription().getValue());
        Group_Test.assertEquals((String)"descKey", (String)this.clonedGroup.getDescription().getTranslationKey());
        Group_Test.assertEquals((String)"desc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        Group_Test.assertEquals((String)"descKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        Group_Test.assertEquals((String)"shortDesc", (String)this.group.getShortDescription().getValue());
        Group_Test.assertEquals((String)"shortDescKey", (String)this.group.getShortDescription().getTranslationKey());
        Group_Test.assertEquals((String)"shortDesc", (String)this.clonedGroup.getShortDescription().getValue());
        Group_Test.assertEquals((String)"shortDescKey", (String)this.clonedGroup.getShortDescription().getTranslationKey());
        Group_Test.assertEquals((String)"shortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        Group_Test.assertEquals((String)"shortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetDefault() {
        this.group.setDefault(Boolean.FALSE);
        Group_Test.assertFalse((boolean)this.group.getDefault());
        Group_Test.assertFalse((boolean)Boolean.parseBoolean(this.element.getAttribute("default")));
    }

    public void testSetGroupID() {
        this.group.setGroupID("differentID");
        Group_Test.assertEquals((String)"differentID", (String)this.group.getGroupID());
        Group_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("id"));
        try {
            this.group.setGroupID(null);
            Group_Test.fail((String)"ID was set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetSelectedFeatures() {
        this.group.setSelectedFeatures((Collection<String>)Arrays.asList("feature3"));
        Group_Test.assertEquals((int)1, (int)this.group.getSelectedFeatures().size());
        Group_Test.assertEquals((String)"feature3", (String)this.group.getSelectedFeatures().toArray(new String[0])[0]);
        Group_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "SelectedFeature").size());
        Group_Test.assertEquals((String)"feature3", (String)this.session.getChildren(this.element, "SelectedFeature").toArray(new Element[0])[0].getAttribute("featureRef"));
        try {
            this.group.setSelectedFeatures(null);
            Group_Test.fail((String)"SelectedFeatures set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetDisplayName() {
        this.group.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        Group_Test.assertEquals((String)"differentName", (String)this.group.getDisplayName().getValue());
        Group_Test.assertEquals((String)"differentNameKey", (String)this.group.getDisplayName().getTranslationKey());
        Group_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        Group_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetDescription() {
        this.group.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        Group_Test.assertEquals((String)"differentDesc", (String)this.group.getDescription().getValue());
        Group_Test.assertEquals((String)"differentDescKey", (String)this.group.getDescription().getTranslationKey());
        Group_Test.assertEquals((String)"differentDesc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        Group_Test.assertEquals((String)"differentDescKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.group.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));
        Group_Test.assertEquals((String)"differentShortDesc", (String)this.group.getShortDescription().getValue());
        Group_Test.assertEquals((String)"differentShortDescKey", (String)this.group.getShortDescription().getTranslationKey());
        Group_Test.assertEquals((String)"differentShortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        Group_Test.assertEquals((String)"differentShortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

