/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.w3c.dom.Element;

public class Language_Test
extends TestCase {
    Language lang;
    Language clonedLang;
    Element element;
    SPISessionImpl session;

    public Language_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.lang = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langType");
        this.lang.setDisplayName(new TranslatableString("displayName", "displayNameKey"));
        this.lang.setDescription(new TranslatableString("desc", "descKey"));
        this.lang.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        this.clonedLang = (Language)this.lang.clone();
        this.element = ((SPIDataObject)((Object)this.lang)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = this.lang.getTranslatableStrings();
        Properties clonedProps = this.clonedLang.getTranslatableStrings();
        Language_Test.assertEquals((int)3, (int)props.keySet().size());
        Language_Test.assertEquals((int)3, (int)clonedProps.keySet().size());
        Language_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        Language_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        Language_Test.assertEquals((Object)"displayName", (Object)props.get("displayNameKey"));
        Language_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
        Language_Test.assertEquals((Object)"shortDesc", (Object)clonedProps.get("shortDescKey"));
        Language_Test.assertEquals((Object)"displayName", (Object)clonedProps.get("displayNameKey"));
    }

    public void testGetType() {
        Language_Test.assertEquals((String)"langType", (String)this.lang.getType());
        Language_Test.assertEquals((String)"langType", (String)this.clonedLang.getType());
        Language_Test.assertEquals((String)"langType", (String)this.element.getAttribute("type"));
    }

    public void testGetDisplayName() {
        Language_Test.assertEquals((String)"displayName", (String)this.lang.getDisplayName().getValue());
        Language_Test.assertEquals((String)"displayNameKey", (String)this.lang.getDisplayName().getTranslationKey());
        Language_Test.assertEquals((String)"displayName", (String)this.clonedLang.getDisplayName().getValue());
        Language_Test.assertEquals((String)"displayNameKey", (String)this.clonedLang.getDisplayName().getTranslationKey());
        Language_Test.assertEquals((String)"displayName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        Language_Test.assertEquals((String)"displayNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDescription() {
        Language_Test.assertEquals((String)"desc", (String)this.lang.getDescription().getValue());
        Language_Test.assertEquals((String)"descKey", (String)this.lang.getDescription().getTranslationKey());
        Language_Test.assertEquals((String)"desc", (String)this.clonedLang.getDescription().getValue());
        Language_Test.assertEquals((String)"descKey", (String)this.clonedLang.getDescription().getTranslationKey());
        Language_Test.assertEquals((String)"desc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        Language_Test.assertEquals((String)"descKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        Language_Test.assertEquals((String)"shortDesc", (String)this.lang.getShortDescription().getValue());
        Language_Test.assertEquals((String)"shortDescKey", (String)this.lang.getShortDescription().getTranslationKey());
        Language_Test.assertEquals((String)"shortDesc", (String)this.clonedLang.getShortDescription().getValue());
        Language_Test.assertEquals((String)"shortDescKey", (String)this.clonedLang.getShortDescription().getTranslationKey());
        Language_Test.assertEquals((String)"shortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        Language_Test.assertEquals((String)"shortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetType() {
        this.lang.setType("differentType");
        Language_Test.assertEquals((String)"differentType", (String)this.lang.getType());
        Language_Test.assertEquals((String)"differentType", (String)this.element.getAttribute("type"));
        try {
            this.lang.setType(null);
            Language_Test.fail((String)"Type set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetDisplayName() {
        this.lang.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        Language_Test.assertEquals((String)"differentName", (String)this.lang.getDisplayName().getValue());
        Language_Test.assertEquals((String)"differentNameKey", (String)this.lang.getDisplayName().getTranslationKey());
        Language_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getTextContent());
        Language_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.element, "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetDescription() {
        this.lang.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        Language_Test.assertEquals((String)"differentDesc", (String)this.lang.getDescription().getValue());
        Language_Test.assertEquals((String)"differentDescKey", (String)this.lang.getDescription().getTranslationKey());
        Language_Test.assertEquals((String)"differentDesc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        Language_Test.assertEquals((String)"differentDescKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.lang.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));
        Language_Test.assertEquals((String)"differentShortDesc", (String)this.lang.getShortDescription().getValue());
        Language_Test.assertEquals((String)"differentShortDescKey", (String)this.lang.getShortDescription().getTranslationKey());
        Language_Test.assertEquals((String)"differentShortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        Language_Test.assertEquals((String)"differentShortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

