/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeRequiredBaseConstraintImpl
extends NameableObject
implements AlternativeRequiredBaseConstraint {
    private static final String ALTERNATIVE_REQUIRED_BASE_CONSTRAINT_TYPE = "sdd-dd:AlternativeRequiredBaseConstraintType";

    public AlternativeRequiredBaseConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, ALTERNATIVE_REQUIRED_BASE_CONSTRAINT_TYPE);
    }

    @Override
    public String getID() {
        return this.getAttribute("id");
    }

    @Override
    public BigInteger getPriority() {
        BigInteger priority = null;
        if (this.isSetAttribute("priority")) {
            priority = new BigInteger(this.getAttribute("priority"));
        }
        return priority;
    }

    @Override
    public Collection<RequiredBaseConstraint> getRequiredBaseConstraints() {
        Collection<Element> requiredBaseElements = this.getChildren("ResourceConstraint");
        ArrayList<RequiredBaseConstraint> constraints = new ArrayList<RequiredBaseConstraint>();
        for (Element element : requiredBaseElements) {
            RequiredBaseConstraintImpl constraint = new RequiredBaseConstraintImpl(element, this.session);
            constraints.add(constraint);
        }
        return constraints;
    }

    @Override
    public void setID(String id) {
        this.session.testParameter(id, 1, null);
        this.setAttribute("id", id);
    }

    @Override
    public void setPriority(BigInteger priority) {
        if (priority == null) {
            this.unSetAttribute("priority");
        } else {
            this.setAttribute("priority", priority.toString());
        }
    }

    @Override
    public void setRequiredBaseConstraints(Collection<RequiredBaseConstraint> newRequiredBaseConstraints) {
        if (newRequiredBaseConstraints == null) {
            this.unSetElement("ResourceConstraint");
        } else {
            this.removeContent(this.getChildren("ResourceConstraint", false));
            this.addContent(newRequiredBaseConstraints);
        }
    }

    @Override
    public Object clone() {
        return new AlternativeRequiredBaseConstraintImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

