/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.OperationsType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionType {
    static Collection<Completion> merge(Collection<Completion> completions1, Collection<Completion> completions2) {
        ArrayList<Completion> completionsToRemove = new ArrayList<Completion>();
        for (Completion completion1 : completions1) {
            for (Completion completion2 : completions2) {
                if (completionsToRemove.contains(completion2) || !CompletionType.equals(completion1, completion2)) continue;
                completionsToRemove.add(completion2);
                completion1 = CompletionType.merge(completion1, completion2);
            }
        }
        completions2.removeAll(completionsToRemove);
        ArrayList<Completion> finalCompletions = new ArrayList<Completion>();
        finalCompletions.addAll(completions1);
        finalCompletions.addAll(completions2);
        return finalCompletions;
    }

    static boolean equals(Completion c1, Completion c2) {
        boolean equals = true;
        equals = equals && StringType.equals(c1.getCompletionType(), c2.getCompletionType());
        equals = equals && OperationsType.equals(c1.getCompletionOperations(), c2.getCompletionOperations());
        Resource rc1 = Util.resolveResourceRef(c1.getCompletionResourceReference());
        Resource rc2 = Util.resolveResourceRef(c2.getCompletionResourceReference());
        equals = equals && ResourceType.equals(rc1, rc2);
        return equals;
    }

    static Completion merge(Completion c1, Completion c2) {
        c1.setDescription(TranslatableStringType.merge(c1.getDescription(), c2.getDescription()));
        c1.setDisplayName(TranslatableStringType.merge(c1.getDisplayName(), c2.getDisplayName()));
        c1.setShortDescription(TranslatableStringType.merge(c1.getShortDescription(), c2.getShortDescription()));
        return c1;
    }
}

