/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.validation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cosmos.me.internal.deployment.sdd.resources.common.validation.Messages;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.ValidationRule;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.XMLValidationError;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaValidationRule
implements ValidationRule,
ErrorHandler {
    private Collection<File> schemaFiles = new Vector<File>();
    private Map<InputStream, File> streamsToFiles = new HashMap<InputStream, File>();
    private Collection<XMLValidationError> xmlValidationErrorList = new Vector<XMLValidationError>();
    public static String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public <T> SchemaValidationRule(Collection<T> schemaSources) throws IOException, FileNotFoundException {
        for (T schemaSource : schemaSources) {
            if (schemaSource instanceof File) {
                File schemaFile = (File)schemaSource;
                this.addSchemaFile(schemaFile);
            }
            if (!(schemaSource instanceof InputStream)) continue;
            InputStream schemaStream = (InputStream)schemaSource;
            this.addSchemaInputStream(schemaStream);
        }
    }

    public SchemaValidationRule(File schemaFile) throws FileNotFoundException, IOException {
        this.addSchemaFile(schemaFile);
    }

    public SchemaValidationRule(InputStream schemaStream) throws IOException {
        this.addSchemaInputStream(schemaStream);
    }

    @Override
    public Collection<XMLValidationError> validate(InputStream xmlStream) {
        DocumentBuilder builder;
        this.xmlValidationErrorList = new Vector<XMLValidationError>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            factory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            factory.setAttribute(SCHEMA_SOURCE, this.schemaFiles.toArray(new File[0]));
        }
        catch (IllegalArgumentException e) {
            String errorMsg = Messages.getString("SchemaValidationRule.2");
            XMLValidationError validationError = new XMLValidationError(errorMsg, this, e);
            this.xmlValidationErrorList.add(validationError);
            return this.xmlValidationErrorList;
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String errorMsg = Messages.getString("SchemaValidationRule.3");
            XMLValidationError validationError = new XMLValidationError(errorMsg, this, e);
            this.xmlValidationErrorList.add(validationError);
            return this.xmlValidationErrorList;
        }
        builder.setErrorHandler(this);
        try {
            builder.parse(xmlStream);
        }
        catch (IOException e) {
            String errorMsg = Messages.getString("SchemaValidationRule.4");
            XMLValidationError validationError = new XMLValidationError(errorMsg, this, e);
            this.xmlValidationErrorList.add(validationError);
            return this.xmlValidationErrorList;
        }
        catch (SAXException e) {
            String errorMsg = Messages.getString("SchemaValidationRule.5");
            XMLValidationError validationError = new XMLValidationError(errorMsg, this, e);
            this.xmlValidationErrorList.add(validationError);
            return this.xmlValidationErrorList;
        }
        catch (IllegalArgumentException e) {
            String errorMsg = Messages.getString("SchemaValidationRule.6");
            XMLValidationError validationError = new XMLValidationError(errorMsg, this, e);
            this.xmlValidationErrorList.add(validationError);
            return this.xmlValidationErrorList;
        }
        return this.xmlValidationErrorList;
    }

    public Collection<File> getSchemaFiles() {
        return this.schemaFiles;
    }

    public Collection<InputStream> getSchemaInputStreams() {
        return this.streamsToFiles.keySet();
    }

    public void addSchemaFile(File schemaFile) throws IOException, FileNotFoundException {
        if (!schemaFile.exists()) {
            throw new FileNotFoundException(Messages.getString("SchemaValidationRule.0", schemaFile.getName()));
        }
        if (!schemaFile.canRead()) {
            throw new IOException(Messages.getString("SchemaValidationRule.1", schemaFile.getName()));
        }
        this.schemaFiles.add(schemaFile);
    }

    public void removeSchemaFile(File schemaFile) {
        this.schemaFiles.remove(schemaFile);
        if (this.streamsToFiles.containsValue(schemaFile)) {
            for (InputStream stream : this.streamsToFiles.keySet()) {
                if (!this.streamsToFiles.get(stream).equals(schemaFile)) continue;
                this.streamsToFiles.remove(stream);
            }
        }
    }

    public void addSchemaInputStream(InputStream schemaStream) throws IOException {
        File tempFile = File.createTempFile("SchemaFileFromStream", null);
        FileOutputStream out = new FileOutputStream(tempFile);
        byte[] copyBuffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = schemaStream.read(copyBuffer)) != -1) {
            ((OutputStream)out).write(copyBuffer, 0, bytesRead);
        }
        this.streamsToFiles.put(schemaStream, tempFile);
        this.schemaFiles.add(tempFile);
        tempFile.deleteOnExit();
    }

    public void removeSchemaInputStream(InputStream schemaStream) {
        if (this.streamsToFiles.containsKey(schemaStream)) {
            this.removeSchemaFile(this.streamsToFiles.get(schemaStream));
        }
    }

    @Override
    public void error(SAXParseException e) {
        this.addXMLValidationError(e, 2);
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.addXMLValidationError(e, 1);
    }

    @Override
    public void warning(SAXParseException e) {
        this.addXMLValidationError(e, 3);
    }

    private void addXMLValidationError(SAXParseException e, int severity) {
        XMLValidationError validationError = new XMLValidationError(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), this, severity);
        this.xmlValidationErrorList.add(validationError);
    }
}

