/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.StringSubstitution;
import org.w3c.dom.Element;

public class AdditionalContentImpl extends SPIDataObject implements AdditionalContent {
	private static final String ADDITIONAL_CONTENT_TYPE = "sdd-dd:AdditionalContentType";
	
	                           
	public AdditionalContentImpl(Element additionalContent, SPISessionImpl session) {
		super(additionalContent, session, ADDITIONAL_CONTENT_TYPE);
		
	}
	
	public String getContentReference() {
		return isSetAttribute("contentRef") ? getAttribute("contentRef") :  null;
	}

	public String getType() {
		return isSetAttribute("type") ? getAttribute("type") :  null;
	}

	
	public Collection<StringSubstitution> getStringSubstitutions() {
		Collection<Element> substitutionElements = getChildren("Substitution");
		Collection<StringSubstitution> copiedSubstitutions = new ArrayList<StringSubstitution>();

		for (Element strSub : substitutionElements) {
			StringSubstitution temp = new StringSubstitutionImpl(strSub, session);
			copiedSubstitutions.add(temp);
        }
		
		return copiedSubstitutions;
	}

	
	public void setContentReference(String contentReference) {
		session.testParameter(contentReference, 1, null);

		setAttribute("contentRef", contentReference);
	}

	public void setType(String contentType) {
		
		if (contentType == null) {
			unSetAttribute("type");
		}
		else {
			setAttribute("type", contentType);
		}
	}
	
	public void setStringSubstitutions(Collection<StringSubstitution> newStringSubstitutions) {
		if (newStringSubstitutions != null) {
            removeContent(getChildren("Substitution", false));

            addContent(newStringSubstitutions);
        }
        else {
        	unSetElement("Substitution");
        }	
	}

	
	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		AdditionalContentImpl duplicate = new AdditionalContentImpl(copy, session);
		
		return duplicate;
	}
}
