/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityValue;
import org.w3c.dom.Element;

public class CapacityConstraintImpl extends DescribableObject implements CapacityConstraint {
	private static final String CAPACITY_CONSTRAINT_TYPE = "sdd-dd:CapacityConstraintType";
	
	public CapacityConstraintImpl(Element data, SPISessionImpl session) {
		super(data, session, CAPACITY_CONSTRAINT_TYPE);				 
	}
	
	public String getMaximum() {
		return getValue().getMaximum();
	}

	public String getMinimum() {
		return getValue().getMinimum();
	}
	
	public String getRecommendedMaximum() {
		return getValue().getRecommendedMaximum();
	}

	public String getRecommendedMinimum() {
		return getValue().getRecommendedMinimum();
	}

	public String getUnitOfMeasure() {
		return getValue().getUnitOfMeasure();
	}
	
	private CapacityValue getValue() {
		CapacityValue cv = null;
		
		if (isSetElement("Value")) {
			cv = new CapacityValueImpl(getChild("Value", false), session);
		}
		else {
			cv = new CapacityValueImpl(session.createDeploymentElement("Value"), session);
			setContent((SPIDataObject)cv);
		}

		return cv;
	}
	
	public String getPropertyName() {
		return isSetElement("PropertyName") ? getChild("PropertyName").getTextContent() : null;
	}
	
	public void setPropertyName(String propertyName) {
		session.testParameter(propertyName, 1, null);
		
        if (propertyName == null) {
            unSetElement("PropertyName");
        }
        else {
            Element nameElement = session.createDeploymentElement("PropertyName");
            nameElement.setTextContent(propertyName);
            setContent(nameElement);
        }
	}
	
	public void setMaximum(String maximum) {
		getValue().setMaximum(maximum);
	}

	public void setMinimum(String minimum) {
		getValue().setMinimum(minimum);
	}

	public void setRecommendedMaximum(String recommendedMaximum) {
		getValue().setRecommendedMaximum(recommendedMaximum);
	}

	public void setRecommendedMinimum(String recommendedMinimum) {
		getValue().setRecommendedMinimum(recommendedMinimum);
	}

	public void setUnitOfMeasure(String unitOfMeasure) {
		getValue().setUnitOfMeasure(unitOfMeasure);
	}

	public String toString() {
		String capacityConstraintContents = new String("Property name: " + getPropertyName());
		
		CapacityValue cv = getValue();
		
		if (((SPIDataObject)cv).isSetElement("Maximum")) {
			capacityConstraintContents += ", Maximum: " + cv.getMaximum();
		}

		if (((SPIDataObject)cv).isSetElement("Minimum")) {
			capacityConstraintContents += ", Minimum: " + cv.getMinimum();
		}
		
		if (((SPIDataObject)cv).isSetElement("MaximumRecommended")) {
			capacityConstraintContents += ", MaximumRecommended: " + cv.getRecommendedMaximum();
		}
		
		if (((SPIDataObject)cv).isSetElement("MinimumRecommended")) {
			capacityConstraintContents += ", MinimumRecommended: " + cv.getRecommendedMinimum();
		}
				
		if (((SPIDataObject)cv).isSetElement("unit")) {
			capacityConstraintContents += ", unit: " + cv.getUnitOfMeasure();
		}
						
		return capacityConstraintContents + "\n" + super.toString();
	}
		
	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
			
		CapacityConstraint duplicate = new CapacityConstraintImpl(copy, session);
		
		return duplicate;
	}
}