/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentSelectionFeature;
import org.w3c.dom.Element;

public class ContentSelectionFeature_Test extends TestCase
{
    ContentSelectionFeature feature;
    ContentSelectionFeature clonedFeature;
    Element element;

    public ContentSelectionFeature_Test(String name)
    {
        super(name);
    }

    protected void setUp() throws Exception
    {
        super.setUp();
        
        feature = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createContentSelectionFeature("feature");
        
        feature.setSelections("selections");
        
        clonedFeature = (ContentSelectionFeature) feature.clone();
        element = ((SPIDataObject) feature).getElement();
    }

    public void testGetFeature()
    {
        assertEquals("feature", feature.getFeature());
        assertEquals("feature", clonedFeature.getFeature());
        assertEquals("feature", element.getTextContent());
    }

    public void testGetSelections()
    {
        assertEquals("selections", feature.getSelections());
        assertEquals("selections", clonedFeature.getSelections());
        assertEquals("selections", element.getAttribute("selections"));
    }

    public void testSetFeature()
    {
        feature.setFeature("differentFeature");

        assertEquals("differentFeature", feature.getFeature());
        assertEquals("differentFeature", element.getTextContent());
        
        try
        {
            feature.setFeature(null);
            fail("Feature was set to null");
        }
        catch (Exception e)
        {
        }
    }

    public void testSetSelections()
    {
        feature.setSelections("differentSelections");

        assertEquals("differentSelections", feature.getSelections());
        assertEquals("differentSelections", element.getAttribute("selections"));
    }

    public void testGetTranslatableStrings()
    {
        Properties props = ((SPIDataObject) feature).getTranslatableStrings();
        
        assertEquals(0, props.keySet().size());
    }

}
