/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;



/**
 * Objects implementing this interface can have translatable names
 * assigned to them.
 *
 */
public interface Nameable extends Describable, Translatable {
	/**
	 * Gets the Name.
	 * 
	 * @return A TranslatableString object containing a translatable name
	 */
	TranslatableString getName();
	
	/**
	 * Sets the Name.
	 * 
	 * @param name A TranslatableString object containing a translatable name
	 */
	void setName(TranslatableString name);

}
