<?xml version="1.0"?><?xar XSLT?>
<!--
/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" 
	xmlns:sch="http://www.ascc.net/xml/schematron"
	xmlns:iso="http://purl.oclc.org/dsdl/schematron">
	
	<xsl:import href="validation-resources/iso_schematron_skeleton_for_xslt1.xsl"/>

	<!-- 
	     This template overrides a template in the iso schematron to normalize 
	     whitespaces.  The validator will display error messages in one line. 
	-->
	<xsl:template match="text()" mode="text">
		<xsl:value-of select="normalize-space(.)"/>
	</xsl:template>

    <!-- 
         The following template overrides a template in the iso schematron. 
         A space is added before and after a variable evaluated from the "value-of" element.  
         The spaces are required because white spaces are normalized.  
    -->
	<xsl:template match="iso:value-of" mode="text" >
        <xsl:if test="not(@select)">
            <xsl:message>Markup Error: no select attribute in &lt;value-of></xsl:message>
        </xsl:if>
	    <xsl:call-template name="IamEmpty" />
	    <axsl:text xml:space="preserve"> </axsl:text>
		<xsl:choose>
			<xsl:when test="@select">
				<xsl:call-template name="process-value-of">
					<xsl:with-param name="select" select="@select"/>  
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise >
				<xsl:call-template name="process-value-of">
					<xsl:with-param name="select" select="'.'"/>
				</xsl:call-template>
			</xsl:otherwise>
        </xsl:choose> 
        <axsl:text xml:space="preserve"> </axsl:text>
	</xsl:template>	
</xsl:stylesheet>