/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.internal.validation.core;

/**
 * Notify callers of important validation events
 * 
 * @author David Whiteman
 */
public interface IValidationListener {
	/**
	 * A validation error occurred.  Listeners can set the doit flag
	 * in the ValidationEvent to indicate whether validation should continue.
	 * 
	 * @param event
	 */
	public void validationErrorOccurred(ValidationEvent event);
}
