/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.schema.ext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionModel {
    private String _id;
    private HashMap<String, ResolutionObject> _resolutions = new HashMap();
    private HashMap<String, ResolutionObject> _resultingResources = new HashMap();
    private HashMap<String, ResolutionObject> _artifacts = new HashMap();

    public ResolutionModel() {
    }

    public ResolutionModel(String id) {
        this._id = id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public HashMap<String, ResolutionObject> getResolutions() {
        return this._resolutions;
    }

    public HashMap<String, ResolutionObject> getResultingResources() {
        return this._resultingResources;
    }

    public HashMap<String, ResolutionObject> getArtifacts() {
        return this._artifacts;
    }

    public void addResolutionObject(String key, ResolutionObject value) {
        this._resolutions.put(key, value);
    }

    public ResolutionObject getResolutionObject(String key) {
        return this._resolutions.get(key);
    }

    public void unresolve(String key) {
        if (this.getResolutionObject(key) != null) {
            this.getResolutionObject(key).unresolve();
        }
    }

    public void resolve(String key) {
        if (this.getResolutionObject(key) != null) {
            this.getResolutionObject(key).resolve();
        }
    }

    public void accept(String key) {
        if (this.getResolutionObject(key) != null) {
            this.getResolutionObject(key).accept();
        }
    }

    public void reject(String key) {
        if (this.getResolutionObject(key) != null) {
            this.getResolutionObject(key).reject();
        }
    }

    public void addResultingResource(String key, ResolutionObject value) {
        this._resultingResources.put(key, value);
    }

    public void addArtifact(String key, ResolutionObject value) {
        this._artifacts.put(key, value);
    }

    public boolean isResolved() {
        for (ResolutionObject ro : this._resolutions.values()) {
            if (ro.isResolved()) continue;
            return false;
        }
        for (ResolutionObject ro : this._resultingResources.values()) {
            if (ro.isResolved()) continue;
            return false;
        }
        for (ResolutionObject ro : this._artifacts.values()) {
            if (ro.isResolved()) continue;
            return false;
        }
        return true;
    }

    public boolean isUnresolved() {
        for (ResolutionObject ro : this._resolutions.values()) {
            if (!ro.isUnresolved()) continue;
            return true;
        }
        for (ResolutionObject ro : this._resultingResources.values()) {
            if (!ro.isUnresolved()) continue;
            return true;
        }
        for (ResolutionObject ro : this._artifacts.values()) {
            if (!ro.isUnresolved()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String nl = "\n";
        StringBuilder s = new StringBuilder();
        s.append("ResolutionModel: ").append(this._id).append(nl);
        s.append("==========\n");
        s.append("resolutions\n");
        for (Map.Entry<String, ResolutionObject> e : this._resolutions.entrySet()) {
            s.append("----------\n");
            s.append(e.getValue().toString());
        }
        s.append("==========\n");
        s.append("resulting resources\n");
        for (Map.Entry<String, ResolutionObject> e : this._resultingResources.entrySet()) {
            s.append("----------\n");
            s.append(e.getValue().toString());
        }
        s.append("==========\n");
        s.append("artifacts\n");
        for (Map.Entry<String, ResolutionObject> e : this._artifacts.entrySet()) {
            s.append("----------\n");
            s.append(e.getValue().toString());
        }
        return s.toString();
    }
}

