/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim.op;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.cosmos.me.sdd.op.IOperationHandler;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationProgress;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArgumentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.ContentType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class ZipOperation
implements IOperationHandler {
    private InstallationProgress progress;

    public void setProgress(InstallationProgress progress) {
        this.progress = progress;
    }

    public void unsetProgress(InstallationProgress progress) {
        this.progress = null;
    }

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation) {
        this.progress.progressBeginningAction(String.valueOf(this.getClass().getSimpleName()) + "::invokeAction");
        if (ctxt == null || artifact == null) {
            this.progress.progressFailedAction(String.valueOf(this.getClass().getSimpleName()) + "::invokeAction", null);
            return;
        }
        switch (operation) {
            case INSTALL: {
                List arguments;
                ContentType content;
                String srcPath = null;
                if (artifact.getContentRef() != null && (content = ctxt.getContentById(artifact.getContentRef())) != null) {
                    srcPath = content.getPathname();
                }
                if (srcPath == null || (arguments = artifact.getArguments().getArgument()).isEmpty()) break;
                ArgumentType at = (ArgumentType)arguments.get(0);
                String dest = ctxt.substituteVariables(at.getValue());
                InputStream stream = ctxt.getInputStreamForPath(srcPath);
                this.unzip(stream, dest);
                break;
            }
            default: {
                System.out.printf("%s::invokeAction\n", this.getClass().getName());
            }
        }
        this.progress.progressCompleteAction(String.valueOf(this.getClass().getSimpleName()) + "::invokeAction");
    }

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content, OperationType operation) {
    }

    private void unzip(InputStream stream, String path) {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(stream));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String destPath = String.valueOf(path) + File.separator + entry.getName();
                File destDir = new File(destPath);
                if (entry.isDirectory() && !destDir.exists()) {
                    destDir.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(destDir);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                byte[] data = new byte[2048];
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

