/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import java.math.BigInteger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.schema.AlternativeRequirementType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementType;
import org.eclipse.cosmos.me.sdd.schema.RequirementsType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class RequirementsResolver {
    private SDDContext ctxt;
    private ResourceHandler handler;
    public boolean results = false;
    RequirementResourceConstraintType unsatisified;

    public RequirementsResolver(SDDContext ctxt, ResourceHandler handler) {
        this.ctxt = ctxt;
        this.handler = handler;
    }

    public boolean installableUnitResolver() {
        InstallableUnitType iu = this.ctxt.getDeploymentDescriptor().getInstallableUnit();
        this.results = this.resolve(iu.getRequirements());
        return this.results;
    }

    private boolean resolve(RequirementsType requirements) {
        boolean result = true;
        if (requirements != null) {
            for (RequirementType req : requirements.getRequirement()) {
                boolean bl = result = result && this.resolve(req);
            }
        }
        return result;
    }

    private boolean resolve(RequirementType requirement) {
        boolean result = true;
        if (!requirement.getAlternative().isEmpty()) {
            boolean altResult = false;
            BigInteger primary = null;
            for (AlternativeRequirementType req : requirement.getAlternative()) {
                boolean resolved = this.resolve(req);
                if (resolved) {
                    if (primary == null) {
                        primary = req.getPriority();
                    }
                    BigInteger priority = req.getPriority();
                    if (primary != null && priority != null && priority.compareTo(primary) > 0) {
                        primary = priority;
                        req.getOtherAttributes().put(new QName("primary"), "true");
                    }
                }
                boolean bl = altResult = altResult || resolved;
            }
            result = result && altResult;
        }
        for (RequirementResourceConstraintType req : requirement.getResourceConstraint()) {
            boolean bl = result = result && this.resolve(req);
        }
        return result;
    }

    private boolean resolve(AlternativeRequirementType requirement) {
        boolean result = true;
        for (RequirementResourceConstraintType req : requirement.getResourceConstraint()) {
            boolean bl = result = result && this.resolve(req);
        }
        return result;
    }

    private boolean resolve(RequirementResourceConstraintType requirement) {
        boolean result = true;
        ResourceType rsrc = (ResourceType)requirement.getResourceRef();
        if (requirement.getResourceConstraintGroup().size() > 1) {
            result = this.handler.evaluate(this.ctxt, rsrc, requirement);
        } else {
            for (Object o : requirement.getResourceConstraintGroup()) {
                if (!(o instanceof JAXBElement)) continue;
                Object value = ((JAXBElement)o).getValue();
                if (value instanceof PropertyConstraintType) {
                    result = result && this.resolve(rsrc, (PropertyConstraintType)value);
                    continue;
                }
                if (value instanceof ConsumptionConstraintType) {
                    result = result && this.resolve(rsrc, (ConsumptionConstraintType)value);
                    continue;
                }
                if (!(value instanceof VersionConstraintType)) continue;
                boolean bl = result = result && this.resolve(rsrc, (VersionConstraintType)value);
            }
        }
        if (result) {
            requirement.getOtherAttributes().put(new QName("satisfied"), "true");
        } else {
            requirement.getOtherAttributes().put(new QName("satisfied"), "false");
        }
        return result;
    }

    private boolean resolve(ResourceType rsrc, VersionConstraintType constraint) {
        boolean result = this.handler.evaluate(this.ctxt, rsrc, constraint);
        return result;
    }

    private boolean resolve(ResourceType rsrc, PropertyConstraintType constraint) {
        boolean result = this.handler.evaluate(this.ctxt, rsrc, constraint);
        return result;
    }

    private boolean resolve(ResourceType rsrc, ConsumptionConstraintType constraint) {
        boolean result = this.handler.evaluate(this.ctxt, rsrc, constraint);
        Long value = (Long)this.handler.getPropertyValue(this.ctxt, rsrc, constraint.getPropertyName());
        constraint.getValue().getOtherAttributes().put(new QName("actual"), value.toString());
        return result;
    }

    public RequirementResourceConstraintType getUnsatisifiedResource() {
        InstallableUnitType iu = this.ctxt.getDeploymentDescriptor().getInstallableUnit();
        RequirementsType requirements = iu.getRequirements();
        if (requirements != null) {
            for (RequirementType requirement : requirements.getRequirement()) {
                for (AlternativeRequirementType req : requirement.getAlternative()) {
                    for (RequirementResourceConstraintType req2 : req.getResourceConstraint()) {
                        String value = (String)req2.getOtherAttributes().get(new QName("satisified"));
                        if (!"false".equals(value)) continue;
                        return req2;
                    }
                }
                for (AlternativeRequirementType req : requirement.getResourceConstraint()) {
                    String value = (String)req.getOtherAttributes().get(new QName("satisified"));
                    if (!"false".equals(value)) continue;
                    return req;
                }
            }
        }
        return null;
    }
}

