/***********************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.log.impl;

import org.apache.log4j.Logger;
import org.eclipse.cosmos.me.sdd.log.LogHandler;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogService;

public class Log4JLogger implements LogHandler {

	Logger logger = Logger.getLogger(Log4JLogger.class);
	
	public void logged(LogEntry entry) {

		int level = entry.getLevel();
		if(level == LogService.LOG_DEBUG) {
			logger.debug(entry.getMessage());
		}
		else if (level == LogService.LOG_ERROR) {
			logger.error(entry.getMessage());
		}
		else if (level == LogService.LOG_INFO) {
			logger.info(entry.getMessage());
		}
		else if (level == LogService.LOG_WARNING) {
			logger.warn(entry.getMessage());
		}
		else {
			logger.fatal(entry.getMessage());
		}
	}
}
