/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.op.listener;

/**
 * Interface for implementing listeners that watch for rollback events.
 * @author jehamm
 *
 */
public interface InstallationRollbackListener extends InstallListener {

	public void rollbackProgressBeginningAction(String action, EntryData metaData); 
	// action is one of OperationController.ADDED_FILE, OperationController.REMOVED_FILE, or OperationController.DELETED_FILE
	
	public void rollbackProgressBeginningAction(String description);
	
	public void rollbackProgressCompleteAction(String action, EntryData metaData); 
	// action is one of OperationController.ADDED_FILE, OperationController.REMOVED_FILE, or OperationController.DELETED_FILE
	
	public void rollbackProgressCompleteAction(String description);
	
	public void rollbackBytesMoved(long numBytes);
	
	public void rollbackFailure(String description);
	
	public void allRollbackCompleteAction();

}
