/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.op.listener.event;

import org.eclipse.cosmos.me.sdd.op.listener.InstallationRollbackListener;

public interface InstallationRollback extends InstallationRollbackListener {
	public static final String ACTION = "action";
	public static final String METADATA = "metadata";
	public static final String DESCRIPTION = "description";
	public static final String BYTES = "bytes";

	public enum Topic {
		FILTER("sdd/install/rollback/*"),
		BEGINNING("sdd/install/rollback/beginning"),
		COMPLETE("sdd/install/rollback/complete"),
		FAILURE("sdd/install/rollback/failure"),
		BYTES_MOVED("sdd/install/rollback/bytesmoved"),
		ALL_COMPLETE("sdd/install/rollback/allcomplete"),
		UNKNOWN("unknown");
		
		private String value;
		
		Topic(String value) {
			this.value = value;
		}
		
		public String value() {
			return value;
		}
		
		public static Topic getValue(String value) {
			for (Topic t : values()) {
				if (t.value().equals(value)) return t;
			}
			return UNKNOWN;
		}
	}
}
