/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.PropertyType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceType {
    public static Collection<Resource> merge(Collection<Resource> resources1, Collection<Resource> resources2) {
        ArrayList<Resource> resourcesToRemove = new ArrayList<Resource>();
        for (Resource resource1 : resources1) {
            for (Resource resource2 : resources2) {
                if (resourcesToRemove.contains(resource2) || !ResourceType.equals(resource1, resource2)) continue;
                resourcesToRemove.add(resource2);
                resource1.setHostedResources(ResourceType.merge(resource1.getHostedResources(), resource2.getHostedResources()));
            }
        }
        resources2.removeAll(resourcesToRemove);
        ArrayList<Resource> finalResources = new ArrayList<Resource>();
        finalResources.addAll(resources1);
        finalResources.addAll(resources2);
        return finalResources;
    }

    public static boolean equals(Resource resource1, Resource resource2) {
        try {
            if (!StringType.equals(resource1.getResourceType(), resource2.getResourceType())) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Required parameter \"Type\" missing from resource");
            return false;
        }
        if (resource1.getProperties() != null && resource2.getProperties() == null) {
            return false;
        }
        if (resource1.getProperties() == null && resource2.getProperties() != null) {
            return false;
        }
        if (resource1.getProperties() != null && resource2.getProperties() != null && !PropertyType.equals(resource1.getProperties(), resource2.getProperties())) {
            return false;
        }
        if (resource1.getName() != null && resource2.getName() == null) {
            return false;
        }
        if (resource1.getName() == null && resource2.getName() != null) {
            return false;
        }
        return resource1.getName() == null || resource2.getName() == null || StringType.equals(resource1.getName(), resource2.getName());
    }
}

