/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyValueList;
import org.w3c.dom.Element;

public class PropertyValueListImpl extends SPIDataObject implements PropertyValueList {
	private static final String PROPERTY_VALUE_LIST_TYPE = "sdd-dd:PropertyValueListType";

	public PropertyValueListImpl(Element data, SPISessionImpl session) {
		super(data, session, PROPERTY_VALUE_LIST_TYPE);
	}
	
	public String getMatch() {
		return isSetAttribute("match") ? getAttribute("match") :  null;
	}

	public Collection<String> getValue() {
		Collection<Element> valueElements = getChildren("Value");
		Collection<String> values = new ArrayList<String>();

		for (Element v : valueElements) {
			String temp = v.getTextContent();
			values.add(temp);
        }
		 
		return values;
	}

	public void setMatch(String match) {
		if (match == null) {
			unSetAttribute("match");
		}
		else {
			setAttribute("match", match);
		}
	}

	public void setValue(Collection<String> value) {
		if (value != null) {
            removeContent(getChildren("Value", false));

            addContent(value);
        }
        else {
        	unSetElement("Value");
        }
	}
}