/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * LanguageSetType provides the type definition for the OptionalLanguages elements of CompositeInstallable and Feature. 
 * It defines a set of languages that can be selected together. 
 */
public interface LanguageSet extends DisplayNameable {
    /**
     * Gets a collection of languages.
     * 
     * The languages defined in this element MUST be selected together. 
     * 
     * @return A collection of languages.
     */
    Collection<Language> getLanguages();
    
    /**
     * Sets the collection of languages.
     * 
     * The languages defined in this element MUST be selected together. 
     * 
     * @param languages A collection of languages.
     * @throws InvalidInputException if the parameter is null
     */
    void setLanguages(Collection<Language> languages);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
    public Object clone();
}
