/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.smlvalidators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathFunctionException;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.artifacts.AcyclicStructure;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DOMStructure;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AcyclicDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.reference.DerefXPathFunction;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcyclicValidator
extends AbstractSMLValidator {
    private List<ResolvedReference> graphNodes = new ArrayList<ResolvedReference>();
    private AcyclicStructure acyclicStructure;
    private DOMStructure domDocuments;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.getInstanceLevelRegistry();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList", new AcyclicDataBuilder());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationAcyclic);
        this.isSyntaxValid();
        this.acyclicStructure = (AcyclicStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList");
        this.domDocuments = (DOMStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        String[] acyclicTypes = this.acyclicStructure.keys();
        this.acyclicStructure.setAllNodes();
        int i = 0;
        while (i < acyclicTypes.length) {
            AcyclicStructure.AcyclicEntry[] entries = this.acyclicStructure.get(acyclicTypes[i]);
            int j = 0;
            while (j < entries.length) {
                ResolvedReference resolvedReference;
                Node documentNode;
                this.graphNodes.clear();
                String ownerAlias = entries[j].getOwnerAlias();
                Node node = documentNode = ownerAlias == null ? this.domDocuments.getOrphan(entries[j].getDocumentPosition()) : this.domDocuments.get(ownerAlias);
                if (documentNode != null && !this.graphNodes.contains(resolvedReference = new ResolvedReference(ownerAlias, documentNode))) {
                    this.graphNodes.add(resolvedReference);
                }
                if (this.isCyclePresent(entries[j])) {
                    String typeName = entries[j].getType().getName();
                    typeName = typeName == null ? SMLValidationMessages.commonAnonymous : typeName;
                    this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(entries[j].getLineNumber(), NLS.bind((String)SMLValidationMessages.acyclicCycleFound, (Object)typeName)));
                    this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(entries[j].getLineNumber(), NLS.bind((String)SMLValidationMessages.acyclicDetectedCycle, (Object)this.graphNodestoString())));
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean isSyntaxValid() {
        XSModel xsModel = (XSModel)this.getAttributes().get("xs.model");
        boolean status = true;
        if (xsModel == null) {
            return status;
        }
        boolean shouldAbortOnError = this.shouldAbortOnError();
        XSNamedMap typeDeclarations = xsModel.getComponents((short)15);
        int i = 0;
        int declarationCount = typeDeclarations.getLength();
        while (i < declarationCount && (!shouldAbortOnError || status)) {
            String acylicValue;
            XSComplexTypeDefinition typeDefinition = (XSComplexTypeDefinition)typeDeclarations.item(i);
            AbstractDataBuilder.AnnotationResult annotationResult = SMLValidatorUtil.retrieveAnnotation((XSTypeDefinition)typeDefinition, "http://www.w3.org/ns/sml", "acyclic", true);
            if (annotationResult != null && SMLValidatorUtil.isFalse(acylicValue = annotationResult.getNodes()[0].getNodeValue())) {
                XSTypeDefinition type = annotationResult.getType();
                XSTypeDefinition baseType = type.getBaseType();
                while (baseType != null && !SMLValidatorUtil.isAnyType(baseType)) {
                    AbstractDataBuilder.AnnotationResult baseResult = SMLValidatorUtil.retrieveAnnotation(baseType, "http://www.w3.org/ns/sml", "acyclic", false);
                    if (baseResult != null && SMLValidatorUtil.isTrue(baseResult.getNodes()[0].getNodeValue())) {
                        this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.acyclicBadDerivation, (Object[])new String[]{typeDefinition.getName(), baseType.getName()})));
                        status = false;
                        break;
                    }
                    baseType = type.getBaseType();
                }
            }
            ++i;
        }
        XSNamedMap elementDeclarations = xsModel.getComponents((short)2);
        int i2 = 0;
        int declarationCount2 = elementDeclarations.getLength();
        while (i2 < declarationCount2 && (!shouldAbortOnError || status)) {
            XSElementDeclaration elementDeclaration = (XSElementDeclaration)elementDeclarations.item(i2);
            AbstractDataBuilder.AnnotationResult result = SMLValidatorUtil.retrieveAnnotation(elementDeclaration, "http://www.w3.org/ns/sml", "acyclic");
            if (result != null) {
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, NLS.bind((String)SMLValidationMessages.acyclicBadDeclaration, (Object)elementDeclaration.getName())));
            }
            ++i2;
        }
        return status;
    }

    private String graphNodestoString() {
        if (this.graphNodes.size() > 0) {
            this.graphNodes.add(this.graphNodes.get(0));
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int gnCount = this.graphNodes.size();
        while (i < gnCount) {
            sb.append(i > 0 ? ", " : "");
            sb.append(this.graphNodes.get(i).reference);
            ++i;
        }
        return sb.toString();
    }

    private boolean isCyclePresent(AcyclicStructure.AcyclicEntry acyclicEntry) {
        ResolvedReference resolvedReference = this.resolveReference(acyclicEntry);
        if (resolvedReference != null) {
            if (this.graphNodes.contains(resolvedReference)) {
                return true;
            }
            this.graphNodes.add(resolvedReference);
            AcyclicStructure.AcyclicEntry[] entries = this.retrieveAcyclicEntries(AcyclicStructure.AcyclicEntry.getOwnerAlias(this.domDocuments.getAliases(resolvedReference.targetDocumentNode)), this.domDocuments.getOrphan(resolvedReference.targetDocumentNode), resolvedReference.targetNode, acyclicEntry.getType());
            int i = 0;
            while (i < entries.length) {
                boolean cycle = this.isCyclePresent(entries[i]);
                if (cycle) {
                    return true;
                }
                ++i;
            }
            this.graphNodes.remove(resolvedReference);
        }
        return false;
    }

    private AcyclicStructure.AcyclicEntry[] retrieveAcyclicEntries(String alias, int orphanIndex, Node node, XSComplexTypeDefinition type) {
        ArrayList<AcyclicStructure.AcyclicEntry> acyclicEntries = new ArrayList<AcyclicStructure.AcyclicEntry>();
        this.retrieveAcyclicEntries(acyclicEntries, alias, orphanIndex, node, type);
        return acyclicEntries.toArray(new AcyclicStructure.AcyclicEntry[acyclicEntries.size()]);
    }

    private void retrieveAcyclicEntries(List<AcyclicStructure.AcyclicEntry> entries, String alias, int orphanIndex, Node node, XSComplexTypeDefinition type) {
        if (this.checkNodeType(node, type)) {
            this.addAcyclicEntry(entries, alias, orphanIndex, node, type);
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            this.retrieveAcyclicEntries(entries, alias, orphanIndex, children.item(i), type);
            ++i;
        }
    }

    private boolean checkNodeType(Node node, XSComplexTypeDefinition type) {
        if (node.getNodeType() != 1) {
            return false;
        }
        ElementPSVI elementPSVI = (ElementPSVI)node;
        XSElementDeclaration elementDeclaration = elementPSVI.getElementDeclaration();
        if (elementDeclaration == null) {
            return false;
        }
        XSTypeDefinition typeDefinition = elementPSVI.getElementDeclaration().getTypeDefinition();
        return this.isEqual(typeDefinition, type);
    }

    private boolean isEqual(XSTypeDefinition actual, XSComplexTypeDefinition expected) {
        if (SMLValidatorUtil.isAnyType(actual) || actual.getTypeCategory() != 15) {
            return false;
        }
        return this.isEqual(actual.getNamespace(), expected.getNamespace()) && this.isEqual(actual.getName(), expected.getName()) ? true : this.isEqual(((XSComplexTypeDefinition)actual).getBaseType(), expected);
    }

    private boolean isEqual(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str1);
    }

    private void addAcyclicEntry(List<AcyclicStructure.AcyclicEntry> entries, String alias, int orphanIndex, Node node, XSComplexTypeDefinition type) {
        AcyclicStructure.AcyclicEntry[] discoveredEntries = this.acyclicStructure.get(type, alias, orphanIndex);
        int i = 0;
        while (i < discoveredEntries.length) {
            if (discoveredEntries[i].getSmlReferenceNode().equals(node)) {
                entries.add(discoveredEntries[i]);
                return;
            }
            ++i;
        }
    }

    private ResolvedReference resolveReference(AcyclicStructure.AcyclicEntry acyclicEntry) {
        block6: {
            Node documentNode;
            ArrayList<String> arguments;
            String reference;
            block5: {
                reference = acyclicEntry.getReference();
                if (reference == null) {
                    return null;
                }
                arguments = new ArrayList<String>();
                arguments.add(reference);
                documentNode = SMLValidatorUtil.findDocumentNode(acyclicEntry.getAliases(), acyclicEntry.getDocumentPosition());
                if (documentNode != null) break block5;
                return null;
            }
            try {
                NodeList result;
                DerefXPathFunction derefFunction = DerefXPathFunction.instance();
                derefFunction.setNamespaceContext(SMLValidatorUtil.buildNamespaceContext(documentNode, acyclicEntry.getNodePath()));
                derefFunction.setDocumentNode(documentNode);
                Object output = derefFunction.evaluate(arguments);
                if (output instanceof NodeList && (result = (NodeList)output).getLength() == 1) {
                    return new ResolvedReference(reference, result.item(0));
                }
            }
            catch (XPathFunctionException e) {
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.errorReferenceResolving, (Object)reference)));
                String exceptionMessage = e.getMessage();
                if (exceptionMessage == null || exceptionMessage.length() <= 0) break block6;
                this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.errorReferenceResolving, (Object)reference)));
            }
        }
        return null;
    }

    private static class ResolvedReference {
        private String reference;
        private Node targetNode;
        private Node targetDocumentNode;

        public ResolvedReference(String reference, Node resolvedReference) {
            this.reference = reference;
            this.targetNode = resolvedReference;
            this.targetDocumentNode = this.targetNode.getOwnerDocument();
        }

        public String getAlias() {
            int hashInx = this.reference.indexOf(35);
            return hashInx >= 0 ? this.reference.substring(0, hashInx) : this.reference;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResolvedReference)) {
                return false;
            }
            ResolvedReference other = (ResolvedReference)o;
            return this.targetNode == null ? other.targetNode == null : this.targetNode.equals(other.targetNode);
        }
    }
}

