/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.PackageFeatureReference;
import org.w3c.dom.Element;

public class PackageFeatureReference_Test
extends TestCase {
    PackageFeatureReference featureRef;
    PackageFeatureReference clonedFeatureRef;
    Element element;

    public PackageFeatureReference_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.featureRef = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createPackageFeatureReference("contentRef", "featureRef");
        this.clonedFeatureRef = (PackageFeatureReference)this.featureRef.clone();
        this.element = ((SPIDataObject)((Object)this.featureRef)).getElement();
    }

    public void testGetContentElementRef() {
        PackageFeatureReference_Test.assertEquals((String)"contentRef", (String)this.featureRef.getContentElementRef());
        PackageFeatureReference_Test.assertEquals((String)"contentRef", (String)this.clonedFeatureRef.getContentElementRef());
        PackageFeatureReference_Test.assertEquals((String)"contentRef", (String)this.element.getAttribute("contentElementRef"));
    }

    public void testGetPackageFeatureRef() {
        PackageFeatureReference_Test.assertEquals((String)"featureRef", (String)this.featureRef.getPackageFeatureRef());
        PackageFeatureReference_Test.assertEquals((String)"featureRef", (String)this.clonedFeatureRef.getPackageFeatureRef());
        PackageFeatureReference_Test.assertEquals((String)"featureRef", (String)this.element.getAttribute("packageFeatureRef"));
    }

    public void testSetContentElementRef() {
        this.featureRef.setContentElementRef("differentRef");
        PackageFeatureReference_Test.assertEquals((String)"differentRef", (String)this.featureRef.getContentElementRef());
        PackageFeatureReference_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("contentElementRef"));
        try {
            this.featureRef.setContentElementRef(null);
            PackageFeatureReference_Test.fail((String)"ContentElementRef set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetPackageFeatureRef() {
        this.featureRef.setPackageFeatureRef("differentFeatureRef");
        PackageFeatureReference_Test.assertEquals((String)"differentFeatureRef", (String)this.featureRef.getPackageFeatureRef());
        PackageFeatureReference_Test.assertEquals((String)"differentFeatureRef", (String)this.element.getAttribute("packageFeatureRef"));
        try {
            this.featureRef.setPackageFeatureRef(null);
            PackageFeatureReference_Test.fail((String)"PackageFeatureRef set to null");
        }
        catch (Exception exception) {}
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.featureRef)).getTranslatableStrings();
        PackageFeatureReference_Test.assertEquals((int)0, (int)props.keySet().size());
    }
}

