/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.w3c.dom.Element;

public class ResourcePropertyImpl extends BaseVariableImpl implements ResourceProperty {
	private static final String RESOURCE_PROPERTY_TYPE = "sdd-dd:ResourcePropertyType";

	public ResourcePropertyImpl (Element data, SPISessionImpl session) {
		super(data, session, RESOURCE_PROPERTY_TYPE);
	}
	
	public String getPropertyName() {
		return getAttribute("propertyName");
	}

	public String getResourceReference() {
		return getAttribute("resourceRef");
	}

	public void setPropertyName(String propertyName) {
		session.testParameter(propertyName, 1, null);
		
		setAttribute("propertyName", propertyName);
	}

	public void setResourceReference(String resourceReference) {
	    session.testParameter(resourceReference, 1, null);
	    
		setAttribute("resourceRef", resourceReference);
	}

	public Element getResourcePropertyElement() {
		return getElement();
	}

	public Object clone() {
		Element copy = (Element) getElement().cloneNode(true);
		ResourcePropertyImpl duplicate = new ResourcePropertyImpl(copy, session);

		return duplicate;
	}
}