/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class MaintenanceInformation_Test extends TestCase {
    MaintenanceInformation info;
    MaintenanceInformation clonedInfo;
    Element element;
    SPISessionImpl session;

    public MaintenanceInformation_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        
        info = SPISession.DEFAULT_INSTANCE.createBaseFactory().createMaintenanceInformation();
        
        TranslatableString str1 = new TranslatableString("cat1", "cat1Key");
        TranslatableString str2 = new TranslatableString("cat2", "cat2Key");
        info.setCategory(Arrays.asList(str1, str2));
        
        FixIdentity fix1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName1");
        FixIdentity fix2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName2");
        info.setFixIdentityDefinitions(Arrays.asList(fix1, fix2));
        
        info.setSeverity(new TranslatableString("sev", "sevKey"));
        
        FixIdentity fix3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName3");
        FixIdentity fix4 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName4");
        MaintenanceInformation info1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createSupersedes();
        info1.setFixIdentityDefinitions(Arrays.asList(fix3));
        MaintenanceInformation info2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createSupersedes();
        info2.setFixIdentityDefinitions(Arrays.asList(fix4));
        info.setSupersedes(Arrays.asList(info1, info2));
        
        clonedInfo = (MaintenanceInformation)info.clone();
        element = ((SPIDataObject)info).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)info).getTranslatableStrings();
        Properties clonedProps = ((SPIDataObject)clonedInfo).getTranslatableStrings();
        
        assertEquals(3, props.keySet().size());
        assertEquals(3, clonedProps.keySet().size());
        
        assertEquals("cat1", props.get("cat1Key"));
        assertEquals("cat2", props.get("cat2Key"));
        assertEquals("sev", props.get("sevKey"));

        assertEquals("cat1", clonedProps.get("cat1Key"));
        assertEquals("cat2", clonedProps.get("cat2Key"));
        assertEquals("sev", clonedProps.get("sevKey"));
    }

    public void testGetCategory() {
        assertEquals(2, info.getCategory().size());
        assertEquals("cat1", info.getCategory().toArray(new TranslatableString[0])[0].getValue());
        assertEquals("cat1Key", info.getCategory().toArray(new TranslatableString[0])[0].getTranslationKey());
        assertEquals("cat2", info.getCategory().toArray(new TranslatableString[0])[1].getValue());
        assertEquals("cat2Key", info.getCategory().toArray(new TranslatableString[0])[1].getTranslationKey());
        
        assertEquals(2, clonedInfo.getCategory().size());
        assertEquals("cat1", clonedInfo.getCategory().toArray(new TranslatableString[0])[0].getValue());
        assertEquals("cat1Key", clonedInfo.getCategory().toArray(new TranslatableString[0])[0].getTranslationKey());
        assertEquals("cat2", clonedInfo.getCategory().toArray(new TranslatableString[0])[1].getValue());
        assertEquals("cat2Key", clonedInfo.getCategory().toArray(new TranslatableString[0])[1].getTranslationKey());
        
        assertEquals(2, session.getChildren(element, "Category").size());
        assertEquals("cat1", ( session.getChildren(element, "Category").toArray(new Element[0])[0]).getTextContent());
        assertEquals("cat1Key", ( session.getChildren(element, "Category").toArray(new Element[0])[0]).getAttribute("translationKey"));
        assertEquals("cat2", ( session.getChildren(element, "Category").toArray(new Element[0])[1]).getTextContent());
        assertEquals("cat2Key", ( session.getChildren(element, "Category").toArray(new Element[0])[1]).getAttribute("translationKey"));
    }

    public void testGetFixIdentityDefinitions() {
        assertEquals(2, info.getFixIdentityDefinitions().size());
        assertEquals("fixName1", info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        assertEquals("fixName2", info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[1].getFixName());

        assertEquals(2, clonedInfo.getFixIdentityDefinitions().size());
        assertEquals("fixName1", clonedInfo.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        assertEquals("fixName2", clonedInfo.getFixIdentityDefinitions().toArray(new FixIdentity[0])[1].getFixName());
        
        assertEquals(2, session.getChildren(element, "Fix").size());
        assertEquals("fixName1", session.getChildren(session.getChildren(element, "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        assertEquals("fixName2", session.getChildren(session.getChildren(element, "Fix").toArray(new Element[0])[1], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetSeverity() {
        assertEquals("sev", info.getSeverity().getValue());
        assertEquals("sevKey", info.getSeverity().getTranslationKey());
        
        assertEquals("sev", clonedInfo.getSeverity().getValue());
        assertEquals("sevKey", clonedInfo.getSeverity().getTranslationKey());
        
        assertEquals("sev", ( session.getChildren(element, "Severity").toArray(new Element[0])[0]).getTextContent());
        assertEquals("sevKey", ( session.getChildren(element, "Severity").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testGetSupersedes() {
        assertEquals(2, info.getSupersedes().size());
        assertEquals("fixName3", info.getSupersedes().toArray(new MaintenanceInformation[0])[0].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        assertEquals("fixName4", info.getSupersedes().toArray(new MaintenanceInformation[0])[1].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());

        assertEquals(2, clonedInfo.getSupersedes().size());
        assertEquals("fixName3", clonedInfo.getSupersedes().toArray(new MaintenanceInformation[0])[0].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        assertEquals("fixName4", clonedInfo.getSupersedes().toArray(new MaintenanceInformation[0])[1].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());

        assertEquals(2, session.getChildren(element, "Supersedes").size());
        assertEquals("fixName3", session.getChildren(session.getChildren(session.getChildren(element, "Supersedes").toArray(new Element[0])[0], "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        assertEquals("fixName4", session.getChildren(session.getChildren(session.getChildren(element, "Supersedes").toArray(new Element[0])[1], "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetCategory() {
        TranslatableString str1 = new TranslatableString("cat3", "cat3Key");
        info.setCategory(Arrays.asList(str1));
        
        assertEquals(1, info.getCategory().size());
        assertEquals("cat3", info.getCategory().toArray(new TranslatableString[0])[0].getValue());
        assertEquals("cat3Key", info.getCategory().toArray(new TranslatableString[0])[0].getTranslationKey());
        
        assertEquals(1, session.getChildren(element, "Category").size());
        assertEquals("cat3", ( session.getChildren(element, "Category").toArray(new Element[0])[0]).getTextContent());
        assertEquals("cat3Key", ( session.getChildren(element, "Category").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testSetFixIdentityDefinitions() {
        FixIdentity fix1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName5");
        info.setFixIdentityDefinitions(Arrays.asList(fix1));

        assertEquals(1, info.getFixIdentityDefinitions().size());
        assertEquals("fixName5", info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());

        assertEquals(1, session.getChildren(element, "Fix").size());
        assertEquals("fixName5", session.getChildren(session.getChildren(element, "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetSeverity() {
        info.setSeverity(new TranslatableString("differentSev", "differentSevKey"));
        
        assertEquals("differentSev", info.getSeverity().getValue());
        assertEquals("differentSevKey", info.getSeverity().getTranslationKey());
        
        assertEquals("differentSev", ( session.getChildren(element, "Severity").toArray(new Element[0])[0]).getTextContent());
        assertEquals("differentSevKey", ( session.getChildren(element, "Severity").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testSetSupersedes() {
        FixIdentity fix6 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName6");
        MaintenanceInformation info1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createSupersedes();
        info1.setFixIdentityDefinitions(Arrays.asList(fix6));
        info.setSupersedes(Arrays.asList(info1));
        
        assertEquals(1, info.getSupersedes().size());
        assertEquals("fixName1", info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());

        assertEquals(1, session.getChildren(element, "Supersedes").size());
        assertEquals("fixName6", session.getChildren(session.getChildren(session.getChildren(element, "Supersedes").toArray(new Element[0])[0], "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }
}
