/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
/**
 * 
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.sdd;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.sdd.SDDDataCollector;
import org.xml.sax.SAXParseException;

/**
 * 
 *
 */
public class SDDDataCollector_Test extends TestCase {
	SDDDataCollector sddDC;
	/**
	 * @param name
	 */
	public SDDDataCollector_Test(String name) {
		super(name);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		sddDC = new SDDDataCollector();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
public void testGetSupportedProperties() throws Exception {
		
		Collection<BTGProperty> btgp = sddDC.getSupportedProperties();
		assertTrue(btgp != null);
		assertEquals(btgp.size(), 1);
		
		BTGProperty testProp = btgp.toArray(new BTGProperty[0])[0];
		
		assertEquals("FileName", testProp.getName());
		assertTrue(testProp.isRequired());
	}
	
	public void testValidDDFile() throws Exception {
		Properties props = new Properties();
		props.put("FileName", AllTests.VALID_DD);
		
		Collection<SDDFragment> sdds = sddDC.collectSDDData(props);
		assertNotNull(sdds);
		assertEquals(sdds.size(), 1);
		
		SDDFragment fragment = sdds.toArray(new SDDFragment[0])[0];
		
		assertTrue(fragment.getFragment().getDocumentElement().getNodeName().equals("sdd-dd:DeploymentDescriptor"));
	}
	
	public void testValidPDFile() throws Exception {
		Properties props = new Properties();
		props.put("FileName", AllTests.VALID_PD);
		
		Collection<SDDFragment> sdds = sddDC.collectSDDData(props);
		assertNotNull(sdds);
		assertEquals(sdds.size(), 1);
		
		SDDFragment fragment = sdds.toArray(new SDDFragment[0])[0];
		
		assertTrue(fragment.getFragment().getDocumentElement().getNodeName().equals("sdd-pd:PackageDescriptor"));
	}
	
	public void testInvalidDDFile() throws Exception {
		Properties props = new Properties();
		props.put("FileName", AllTests.INVALID_DD);
		
		try {
			Collection<SDDFragment> sdds = sddDC.collectSDDData(props);
			fail("Input XML is not well-formed but SAXParseException was not thrown");
		} catch (SAXParseException e) {
			// Expected
		}		
	}
	
	public void testInvalidPDFile() throws Exception {
		Properties props = new Properties();
		props.put("FileName", AllTests.INVALID_PD);
		
		try {
			Collection<SDDFragment> sdds = sddDC.collectSDDData(props);
			fail("Input XML is not well-formed but SAXParseException was not thrown");
		} catch (SAXParseException e) {
			// Expected
		}			
	}
	
	public void testInvalidFileName() throws Exception {
		Properties props = new Properties();
		props.put("FileName", "C:\\badfilename.xml");
		
		try {
			Collection<SDDFragment> sdds = sddDC.collectSDDData(props);
			fail("Did not throw FileNotFoundException when invalid file name is given.");
		} catch (FileNotFoundException e) {
			// Expected
		}
	}
}
