/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Interface containing all API common to both IItem and IRelationship types
 * 
 * 
 * @author David Whiteman
 */
public interface IGraphElement extends IXMLWritable 
{
	
	/**
	 * Answer an array of {@link IRecord} instances specified for this graph
	 * element
	 * 
	 * @return
	 */
	public IRecord[] getRecords();

	
	/**
	 * Associates a set of records with this graph element
	 * 
	 * @param records The set of records to be associated with
	 * this graph element
	 */
	public void setRecords (IRecord[] records);
	

	/**
	 * Add an {@link IRecord} to this graph element
	 * 
	 * @param record
	 */
	public void addRecord(IRecord record);

	
	/**
	 * Removes the record passed in.  This method has no
	 * effect if the record passed in is not associated with this
	 * graph element.
	 * 
	 * @param record The record to be removed.
	 */
	public void removeRecord (IRecord record);
	
	
	/**
	 * Answer an array of {@link IInstanceId} instances specified for this graph
	 * element
	 * 
	 * @return
	 */
	public IInstanceId[] getInstanceIds();

	
	/**
	 * Answer an array of {@link IAdditionalRecordType} instances specified for
	 * this graph element.
	 * 
	 * @return
	 */
	public IAdditionalRecordType[] getAdditionalRecordTypes();


	/**
	 * Add an {@link IAdditionalRecordType} to this graph element
	 * 
	 * @param adt
	 */
	public void addAdditionalRecordType(IAdditionalRecordType adt);

	
	/**
	 * Add an {@link IInstanceId} to this graph element
	 * 
	 * @param instanceId
	 */
	public void addInstanceId(IInstanceId instanceId);
}
