/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ResultingResourceImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstallUnitImpl
extends ContentUnitImpl
implements InstallUnit {
    private static final String INSTALLATION_ARTIFACTS_TYPE = "sdd-dd:InstallationArtifactsType";
    private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";

    public InstallUnitImpl(Element data, SPISessionImpl session, String sddSchemaType) {
        super(data, session, sddSchemaType);
    }

    @Override
    public Artifact getInstallArtifact() {
        Element installArtifactElement;
        ArtifactImpl installArtifact = null;
        if (this.isSetElement("Artifacts") && (installArtifactElement = this.session.getChild(this.getChild("Artifacts"), "InstallArtifact")) != null) {
            installArtifact = new ArtifactImpl(installArtifactElement, this.session);
        }
        return installArtifact;
    }

    @Override
    public String getTargetResourceReference() {
        return this.getAttribute("targetResourceRef");
    }

    @Override
    public Collection<ResultingResource> getResultingResources() {
        Collection<Element> resultingResourceElements = this.getChildren("ResultingResource");
        ArrayList<ResultingResource> resultingResources = new ArrayList<ResultingResource>();
        for (Element element : resultingResourceElements) {
            resultingResources.add(new ResultingResourceImpl(element, this.session));
        }
        return resultingResources;
    }

    @Override
    public Artifact getUpdateArtifact() {
        Element artifactElement;
        ArtifactImpl updateArtifact = null;
        if (this.isSetElement("Artifacts") && (artifactElement = this.session.getChild(this.getChild("Artifacts"), "UpdateArtifact")) != null) {
            updateArtifact = new ArtifactImpl(artifactElement, this.session);
        }
        return updateArtifact;
    }

    @Override
    public Artifact getUndoArtifact() {
        Element artifactElement;
        ArtifactImpl undoArtifact = null;
        if (this.isSetElement("Artifacts") && (artifactElement = this.session.getChild(this.getChild("Artifacts"), "UndoArtifact")) != null) {
            undoArtifact = new ArtifactImpl(artifactElement, this.session);
        }
        return undoArtifact;
    }

    @Override
    public Artifact getUninstallArtifact() {
        Element artifactElement;
        ArtifactImpl uninstallArtifact = null;
        if (this.isSetElement("Artifacts") && (artifactElement = this.session.getChild(this.getChild("Artifacts"), "UninstallArtifact")) != null) {
            uninstallArtifact = new ArtifactImpl(artifactElement, this.session);
        }
        return uninstallArtifact;
    }

    @Override
    public void setResultingResources(Collection<ResultingResource> newResultingResources) {
        this.removeContent(this.getChildren("ResultingResource", false));
        if (newResultingResources != null && !newResultingResources.isEmpty()) {
            this.addContent(newResultingResources);
        }
    }

    @Override
    public void setInstallArtifact(Artifact installArtifact) {
        Element iat = this.getChild("Artifacts");
        if (iat == null) {
            iat = this.session.createDeploymentElement("Artifacts");
        }
        if (installArtifact == null) {
            Element artifact;
            if (this.session.getChildren(iat, "InstallArtifact") != null && this.session.getChildren(iat, "UpdateArtifact") == null && this.session.getChildren(iat, "UndoArtifact") == null && this.session.getChildren(iat, "UninstallArtifact") == null) {
                InvalidInputException e = new InvalidInputException(1, 0);
                this.session.handleInputException(e);
            }
            if ((artifact = this.session.getChild(iat, "InstallArtifact")) != null) {
                iat.removeChild(artifact);
            }
        } else {
            Element artifact = this.session.getChild(iat, "InstallArtifact");
            if (artifact != null) {
                iat.removeChild(artifact);
            }
            this.session.insertNode((Node)iat, (SPIDataObject)((Object)installArtifact), INSTALLATION_ARTIFACTS_TYPE);
        }
        this.setContent(iat);
    }

    @Override
    public void setTargetResourceReference(String targetResourceReference) {
        this.session.testParameter(targetResourceReference, 1, null);
        this.setAttribute("targetResourceRef", targetResourceReference);
    }

    @Override
    public void setUpdateArtifact(Artifact updateArtifact) {
        Element uat = this.getChild("Artifacts");
        if (uat == null) {
            uat = this.session.createDeploymentElement("Artifacts");
        }
        if (updateArtifact == null) {
            Element artifact;
            if (this.session.getChildren(uat, "UpdateArtifact") != null && this.session.getChildren(uat, "InstallArtifact") == null && this.session.getChildren(uat, "UndoArtifact") == null && this.session.getChildren(uat, "UninstallArtifact") == null) {
                InvalidInputException e = new InvalidInputException(1, 0);
                this.session.handleInputException(e);
            }
            if ((artifact = this.session.getChild(uat, "UpdateArtifact")) != null) {
                uat.removeChild(artifact);
            }
        } else {
            Element artifact = this.session.getChild(uat, "UpdateArtifact");
            if (artifact != null) {
                uat.removeChild(artifact);
            }
            this.session.insertNode((Node)uat, (SPIDataObject)((Object)updateArtifact), INSTALLATION_ARTIFACTS_TYPE);
            this.setContent(uat);
        }
    }

    @Override
    public void setUndoArtifact(Artifact undoArtifact) {
        Element uat = this.getChild("Artifacts");
        if (uat == null) {
            uat = this.session.createDeploymentElement("Artifacts");
        }
        if (undoArtifact == null) {
            Element artifact;
            if (this.session.getChildren(uat, "UndoArtifact") != null && this.session.getChildren(uat, "InstallArtifact") == null && this.session.getChildren(uat, "UpdateArtifact") == null && this.session.getChildren(uat, "UninstallArtifact") == null) {
                InvalidInputException e = new InvalidInputException(1, 0);
                this.session.handleInputException(e);
            }
            if ((artifact = this.session.getChild(uat, "UndoArtifact")) != null) {
                uat.removeChild(artifact);
            }
        } else {
            Element artifact = this.session.getChild(uat, "UndoArtifact");
            if (artifact != null) {
                uat.removeChild(artifact);
            }
            this.session.insertNode((Node)uat, (SPIDataObject)((Object)undoArtifact), INSTALLATION_ARTIFACTS_TYPE);
            this.setContent(uat);
        }
    }

    @Override
    public void setUninstallArtifact(Artifact uninstallArtifact) {
        Element uat = this.getChild("Artifacts");
        if (uat == null) {
            uat = this.session.createDeploymentElement("Artifacts");
        }
        if (uninstallArtifact == null) {
            Element artifact;
            if (this.session.getChildren(uat, "UninstallArtifact") != null && this.session.getChildren(uat, "InstallArtifact") == null && this.session.getChildren(uat, "UpdateArtifact") == null && this.session.getChildren(uat, "UndoArtifact") == null) {
                InvalidInputException e = new InvalidInputException(1, 0);
                this.session.handleInputException(e);
            }
            if ((artifact = this.session.getChild(uat, "UninstallArtifact")) != null) {
                uat.removeChild(artifact);
            }
        } else {
            Element artifact = this.session.getChild(uat, "UninstallArtifact");
            if (artifact != null) {
                uat.removeChild(artifact);
            }
            this.session.insertNode((Node)uat, (SPIDataObject)((Object)uninstallArtifact), INSTALLATION_ARTIFACTS_TYPE);
            this.setContent(uat);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public RequiredBase getRequiredBase() {
        RequiredBaseImpl copiedRequiredBase = null;
        if (this.isSetElement("RequiredBase")) {
            copiedRequiredBase = new RequiredBaseImpl(this.getChild("RequiredBase"), this.session);
        }
        return copiedRequiredBase;
    }

    @Override
    public Collection<Requirement> getRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        if (this.isSetElement("Requirements")) {
            Collection<Element> requirementElementList = this.session.getChildren(this.getChild("Requirements"), "Requirement");
            for (Element element : requirementElementList) {
                requirements.add(new RequirementImpl(element, this.session));
            }
        }
        return requirements;
    }

    @Override
    public void setRequiredBase(RequiredBase newRequiredBase) {
        if (newRequiredBase == null) {
            this.unSetElement("RequiredBase");
        } else {
            this.setContent((SPIDataObject)((Object)newRequiredBase));
        }
    }

    @Override
    public void setRequirements(Collection<Requirement> newRequirements) {
        if (newRequirements != null && !newRequirements.isEmpty()) {
            Element requirementsElement = this.isSetElement("Requirements") ? this.getChild("Requirements") : this.session.createDeploymentElement("Requirements");
            Collection<Element> requirementNodeList = this.session.getChildren(requirementsElement, "Requirement");
            for (Element element : requirementNodeList) {
                requirementsElement.removeChild(element);
            }
            for (Requirement requirement : newRequirements) {
                this.session.insertNode((Node)requirementsElement, (SPIDataObject)((Object)requirement), REQUIREMENTS_TYPE);
            }
            this.setContent(requirementsElement);
        } else {
            this.unSetElement("Requirements");
        }
    }
}

