/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;



public class RequiredBaseType {

	/*
	 * RequiredBaseType> 	 	 	 	
		any 	namespace="##other" 	 ?
		DisplayElementGroup 		DisplayElementGroup 	Merge
		Alternative 		<AlternativeRequiredBaseConstraintType> 	Merge
		ResourceConstraint 		<RequiredBaseConstraintType> 	Merge
		any 		namespace="##other" 	 ? 
	 */
	
	public static RequiredBase merge(RequiredBase base1, RequiredBase base2)
	
	{		
		base1.setDisplayName(TranslatableStringType.merge(base1.getDisplayName(),base2.getDisplayName()));
		base1.setAlternativeRequiredBaseConstraints(AlternativeRequiredBaseConstraintType.merge(base1.getAlternativeRequiredBaseConstraints(),base2.getAlternativeRequiredBaseConstraints()));
		base1.setRequiredBaseConstraints(RequiredBaseConstraintType.merge(base1.getRequiredBaseConstraints(),base2.getRequiredBaseConstraints()));
		
		return base1;		
	}
}

