/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.ArtifactFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.StringSubstitution;
import org.w3c.dom.Element;

public class ArtifactFactoryImpl implements ArtifactFactory {
	private SPISessionImpl session;
	private static final String SUBSTITUTION_TYPE = "sdd-dd:SubstitutionType";
	
	public ArtifactFactoryImpl(SPISessionImpl session) {
		this.session = session;
	}

	public AdditionalContent createAdditionalContent(String contentReference) {
		session.testParameter(contentReference, 1, null);

		Element additionalContentElement = session.createDeploymentElement("AdditionalContent");
		additionalContentElement.setAttribute("contentRef", contentReference);
		
		return new AdditionalContentImpl(additionalContentElement, session);
	}

	public Artifact createInstallArtifact() {
		return createArtifact("InstallArtifact");
	}
	
	public Artifact createUninstallArtifact() {
		return createArtifact("UninstallArtifact");
	}
	
	public Artifact createUndoArtifact() {
		return createArtifact("UndoArtifact");
	}
	
	public Artifact createConfigArtifact() {
		return createArtifact("ConfigArtifact");
	}
	
	public Artifact createUpdateArtifact() {
		return createArtifact("UpdateArtifact");
	}
	
	public Artifact createRepairArtifact() {
		return createArtifact("RepairArtifact");
	}
	
	private Artifact createArtifact(String elementName) {
		Element artifactElement = session.createDeploymentElement(elementName);
		return new ArtifactImpl(artifactElement, session);		
	}

	public ArtifactOutputVariable createArtifactOutputVariable(String outputVariableID, String artifactParameter) {
		session.testParameter(outputVariableID, 1, null);
		session.testParameter(artifactParameter, 2, null);
		
		return new ArtifactOutputVariable(outputVariableID,artifactParameter);
	}

	public StringSubstitution createStringSubstitution(String pattern, String value) {
		session.testParameter(pattern, 1, null);
		session.testParameter(value, 2, null);
		
		Element stElement = session.createDeploymentElement("Substitution");
		
		Element patterElement = session.createDeploymentElement("Pattern");
		patterElement.setTextContent(pattern);
		
		Element valueElement = session.createDeploymentElement("Value");
		valueElement.setTextContent(value);
		
		session.insertNode(stElement, patterElement, SUBSTITUTION_TYPE);
		session.insertNode(stElement, valueElement, SUBSTITUTION_TYPE);
		
		return new StringSubstitutionImpl(stElement, session);
	}
}