/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * ResourceMapType is used in the definition of elements that map resources in an SDD to resources in a referenced SDD. The purpose of 
 * a resource map is to identify when two resources in separate SDDs MUST resolve to the same resource instance during any particular 
 * deployment. The characteristics of a mapped resource that are defined in the topology sections of the two SDDs MUST NOT conflict.
 * <ul>For example, if a Name is defined for the resource in both topologies, it MUST be the same in both definitions and if a Property 
 * definition is included for the same property in both places, the value MUST be the same.</ul>
 * Additional characteristics of a mapped resource may be constrained by Requirements or Conditions in either SDD. All constraints on a 
 * mapped resource that are in scope for a particular deployment MUST NOT conflict.<br><br>
 * Resources that are not mapped between the two SDDs MAY resolve to the same instance when their characteristics defined in topology 
 * do not conflict and when the constraints in scope for any particular deployment do not conflict. 
 */
public interface ResourceMap {
	
    /**
     * Gets the resource reference.
     * 
     * The value of the resourceRef MUST be set to the id of the resource in the SDD to be  mapped to a resource in a referenced SDD.
     * 
     * @return Reference to a resource defined in the deployment descriptor.
     */
    String getResourceReference();
    
    /**
     * Gets the foreign ID.
     * 
     * The value MUST reference the id of a resource in the referenced package. This is the resource in the referenced SDD that 
     * MUST resolve to the same resource instance as the resource identified in resourceRef.
     * 
     * @return Reference to a resource defined in a referenced deployment descriptor.
     */
    String getForeignID();
    
    /**
     * Sets the resources reference.
     * 
     * The value of the resourceRef MUST be set to the id of the resource in the SDD to be  mapped to a resource in a referenced SDD.
     * 
     * @param reference Reference to a resource defined in the deployment descriptor.
     */
    void setResourceReference(String reference);
    
    /**
     * Sets the foreign ID.
     * 
     * The value MUST reference the id of a resource in the referenced package. This is the resource in the referenced SDD that 
     * MUST resolve to the same resource instance as the resource identified in resourceRef.
     * 
     * @param id Reference to a resource defined in a referenced deployment descriptor.
     * @throws InvalidInputException if the parameter is null
     */
    void setForeignID(String id);
    
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
