/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.OutputterDelegator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractServletHandler;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IServletHandler;

public class URLDelegator
extends HttpServlet {
    static final long serialVersionUID = -5991590204597891023L;
    protected AbstractServletHandler outputter;
    protected List<IServletHandler> delegators;
    private static ILogger logger = LoggerWrapper.getLogger(URLDelegator.class);

    public URLDelegator() {
        this.setLogger();
    }

    public void init(ServletConfig config) throws ServletException {
        String delegatorStr = config.getServletContext().getInitParameter("DELEGATORS");
        if (delegatorStr != null) {
            String[] delegatorsStrings = delegatorStr.split(",");
            this.delegators = new ArrayList<IServletHandler>();
            int x = 0;
            while (x < delegatorsStrings.length) {
                try {
                    IServletHandler delegator = (IServletHandler)Class.forName(delegatorsStrings[x]).newInstance();
                    this.delegators.add(delegator);
                    delegator.init(config);
                }
                catch (InstantiationException e) {
                    logger.error(e);
                }
                catch (IllegalAccessException e) {
                    logger.error(e);
                }
                catch (ClassNotFoundException e) {
                    logger.error(e);
                }
                ++x;
            }
        }
        this.outputter = this.createOutputterDelegator();
        super.init(config);
        this.outputter.init(config);
    }

    protected AbstractServletHandler createOutputterDelegator() {
        return new OutputterDelegator();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringWriter sw = new StringWriter();
        this.outputter.doGet(req, sw);
        if (this.delegators != null) {
            int x = 0;
            while (x < this.delegators.size()) {
                this.delegators.get(x).doGet(req, sw);
                ++x;
            }
        }
        sw.flush();
        PrintWriter fw = resp.getWriter();
        fw.append(sw.getBuffer().toString());
        fw.close();
        sw.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringWriter sw = new StringWriter();
        this.outputter.doPost(req, sw);
        if (this.delegators != null) {
            int x = 0;
            while (x < this.delegators.size()) {
                this.delegators.get(x).doPost(req, sw);
                ++x;
            }
        }
        sw.flush();
        PrintWriter fw = resp.getWriter();
        fw.append(sw.getBuffer().toString());
        fw.close();
        sw.close();
    }

    protected void setLogger() {
        LoggerWrapper.setLogwrapper(new LoggerWrapper());
    }
}

